<?php $__env->startSection('title', $website_title .' | Privacy Policy'); ?>
<?php ( $meta_description = "Discover how ". $website_title." protects your personal data. Our privacy policy details the measures we take to ensure the security and transparency of your information."); ?>

<?php $__env->startSection('content'); ?>


<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>PRIVACY POLICY</h1>
        <div>
            <p>
            </p>
            <h3><?php echo e(aiTrans('1. Introduction', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('This statement describes the privacy policy adopted by', $locale)); ?> <?php echo e($website_title); ?> ("<?php echo e(aiTrans('we', $locale)); ?>," "<?php echo e(aiTrans('our', $locale)); ?>," "<?php echo e(aiTrans('or', $locale)); ?>")
    <?php echo e(aiTrans('regarding our products and services (the "Services") and', $locale)); ?> <a href="<?php echo e(route('home',)); ?>"><?php echo e(aiTrans('site', $locale)); ?></a>
    <?php echo e(aiTrans('the ("Site")', $locale)); ?>. <?php echo e(aiTrans('Protecting your privacy and the confidentiality of your information is crucial for us when providing our Services and operating the Site.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Our Services and Site may contain links to third-party sites and services. We are not responsible for the privacy practices of these third-party entities. We recommend reviewing their privacy policies before using them.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('All information obtained by us in connection with our Services is treated as confidential. We use robust technical, security, and organizational measures to protect Personal Data (as defined below) against unauthorized processing, accidental loss, destruction, damage, theft, or disclosure.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('By submitting your information through our site, you may be asked to provide personal details such as your name, email, phone number, date of birth, and various identification details. This information may be used, among other purposes, to verify identity, manage information, provide technical support, and fulfill contractual and legal obligations. We may communicate important details via notifications and, with your consent, provide information about products and services via SMS, email, etc. You have the option to manage notification preferences and unsubscribe from certain communications.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('2. Site; Visitors and Users', $locale)); ?></h3>
<h4><?php echo e(aiTrans('2.1. General', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('This section outlines the specifics of data collection from different groups: site visitors ("Visitors"), users ("Users"), and business partners (collectively "Partners"). Personal Data includes IP address, name, contact details, and information about our relationship, as defined by applicable data protection regulations.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.2. Collection and Use', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('By visiting the Site, you consent to the collection and use of your Personal Data. If you do not agree with these terms, you should refrain from visiting the Site. We may collect information through page view activity, IP addresses, and cookies. Additionally, we process data voluntarily provided in forms and registrations.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.3. Purpose of Processing Personal Data', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('We process Personal Data to enhance, understand, and personalize our Site and Services. This includes improving accuracy, communicating about Services, support, contractual obligations, and collaborating with partners. Consent or legal basis is essential for any processing.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('The following describes the purposes and legal basis for processing Personal Data:', $locale)); ?></p>
<table>
    <tbody>
        <tr>
            <td><?php echo e(aiTrans('Account holder registration', $locale)); ?></td>
            <td><?php echo e(aiTrans('Your consent; Execution of Services or contractual obligations', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Provision and use of Services', $locale)); ?></td>
            <td><?php echo e(aiTrans('Execution of Services or contractual obligations', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Operational updates', $locale)); ?></td>
            <td><?php echo e(aiTrans('Execution of Services or contractual obligations', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Responding to inquiries and providing support', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests or execution of Services', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Tailored services, advertising, and marketing', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests or your consent', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Improvement and offering of new Services', $locale)); ?></td>
            <td><?php echo e(aiTrans('Consent and legitimate interests', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Sending advertising and marketing materials', $locale)); ?></td>
            <td><?php echo e(aiTrans('Your consent', $locale)); ?></td>
        </tr>



        <tr>
            <td><?php echo e(aiTrans('Analysis of the effectiveness of marketing campaigns', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests or consent', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Execution of various support activities', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests or execution of Services', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analysis, including statistical analysis', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Protection of interests, rights, and assets', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitimate interests or legal obligations', $locale)); ?></td>
        </tr>
    </tbody>
</table>
<h4><?php echo e(aiTrans('2.4. Sharing of Personal Data', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('We may share information with service providers, Partners, and contractors. For Visitors and Users in the European Data Region, data processing complies with GDPR and applicable Data Protection Laws.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('3. Partners', $locale)); ?></h3>
<h4><?php echo e(aiTrans('3.1. General', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('To provide Services and collaborate with Partners, we collect and process specific types of data. Partners are responsible for their own data, and we may access it through secure means.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.2. Processing of Personal Data', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('We rely on the consent of Partners or legitimate interests to process Personal Data. Data aggregations may be created for development and quality improvement.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.3. Controller/Processor', $locale)); ?></h4>
<p><?php echo e(aiTrans('We may act as a Controller or Processor, depending on the type of data:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Visitor/User Data: Controller', $locale)); ?></li>
    <li><?php echo e(aiTrans('Partner Data: Processor', $locale)); ?></li>
    <li><?php echo e(aiTrans('All data is securely hosted, following the highest security standards. We implement physical, technical, and organizational safeguards.', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('3.4. Third-Party Data Protection', $locale)); ?></h4>
<p><?php echo e(aiTrans('If the Services involve the processing of Personal Data on a third-party platform:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('We act as a Processor', $locale)); ?></li>
    <li><?php echo e(aiTrans('Comply with third-party instructions', $locale)); ?></li>
    <li><?php echo e(aiTrans('Implement security measures', $locale)); ?></li>
    <li><?php echo e(aiTrans('Inform about data breaches', $locale)); ?></li>
    <li><?php echo e(aiTrans('Do not subcontract without consent', $locale)); ?></li>
    <li><?php echo e(aiTrans('Do not process data outside the European Economic Area without consent', $locale)); ?></li>
    <li><?php echo e(aiTrans('For electronic marketing communications, we ensure consent and opt-out options.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('4. Security', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('We use administrative, organizational, and technical safeguards to protect Personal Data from unauthorized access, disclosure, alteration, loss, misuse, or damage. When sharing data with third parties, we ensure they maintain the same data protection standards, and contractual obligations are established for exclusive and secure processing, aligned with this Policy.', $locale)); ?>

</p>


<p>
    <?php echo e(aiTrans('If there is a belief that interaction with us has been compromised, Visitors, Users, or Partners should notify us promptly. It is important to note that despite our security measures, we cannot guarantee complete immunity from third-party attacks. Users acknowledge the inherent risks and possible breaches.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('5. Cookies', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Refer to our', $locale)); ?> <a href="<?php echo e(route('home',)); ?>"><?php echo e(aiTrans('Cookie Policy', $locale)); ?></a> <?php echo e(aiTrans('for detailed information on the types of cookies and tracking technologies used on the Site, reasons for use, and how to accept or reject them.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('6. Links to Other Sites', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('While browsing the Site, Users may encounter links to external sites that are beyond our control. We are not responsible for the content or privacy policies of those sites. Users are advised to review the privacy policies of such third-party sites and services before disclosing any Personal Data.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('7. Retention and Deletion', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Data, including Personal Data, will not be retained for longer than necessary. Visitors and/or Users with active accounts are responsible for the timely deletion of data. After account termination or partnership dissolution, Personal Data collected through the Site and/or Services will be deleted in accordance with applicable laws and our internal policies.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Withdrawal of consent for the processing of Personal Data may limit access to some or all requested Services, without any claims or disputes being applicable.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('8. Your Rights', $locale)); ?></h3>
<p><?php echo e(aiTrans('Users have specific rights regarding their Personal Data:', $locale)); ?></p>
<h4><?php echo e(aiTrans('8.1. Right of Access', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Confirm whether Personal Data is being processed', $locale)); ?></li>
    <li><?php echo e(aiTrans('Access Personal Data and related information', $locale)); ?></li>
    <li><?php echo e(aiTrans('Information about processing purposes, categories, recipients, storage duration, rights, and profiling existence', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.2. Right to Rectification', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Correct inaccurate Personal Data', $locale)); ?></li>
    <li><?php echo e(aiTrans('Complete incomplete Personal Data', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.3. Right to Erasure', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Request the deletion of Personal Data under specific circumstances', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.4. Right to Restriction of Processing', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Obtain processing restriction under specific circumstances', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.5. Right to Data Portability', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Receive Personal Data in a structured and machine-readable format', $locale)); ?></li>
    <li><?php echo e(aiTrans('Transfer Personal Data to another controller', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.6. Right to Object', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Object to processing based on legitimate interests or direct marketing', $locale)); ?></li>
    <li><?php echo e(aiTrans('Stop processing unless there are compelling and/or applicable legal reasons', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.7. Right to Withdraw Consent', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Withdraw consent for the processing of Personal Data at any time', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('9. Advertising and Marketing Materials', $locale)); ?></h3>


<p>
    <?php echo e(aiTrans('Consent is obtained for the use of Personal Data and contact details to provide advertising and marketing materials. Withdrawal of consent is possible by sending a written notice to the provided email address.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('10. Acceptance of this Policy', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('By using the Site and/or Services, Visitors, Users, and/or Partners are presumed to have read and agreed to this Policy. Any disagreement implies abstention from using the platform. We reserve the right to modify the Policy, and Users are encouraged to check for updates periodically. Continued use after changes indicates acceptance.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('11. Legal Obligation to Disclose Personal Data', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Personal Data may be disclosed without prior permission if there is a belief that it is necessary to establish identity, contact, or initiate legal proceedings against individuals suspected of infringing rights or properties. Disclosure will be made when required by law.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('12. Data Protection Officer', $locale)); ?></h3>
<p>
    For privacy and data protection matters, a designated "Data Protection Officer" can be contacted via email at
    <span>info<?php echo e('@'.$website_title); ?></span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>
</div>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/newcccone/public_html/immediatenew.com/resources/views/frontend/en/privacy.blade.php ENDPATH**/ ?>