<?php $__env->startSection('title', $website_title .' | 이용 약관'); ?>
<?php ( $meta_description = "이용 약관을 확인하세요. 우리의 약관은 귀하의 권리와 책임, 그리고 우리의 서비스를 안전하고 효과적으로 사용하는 방법을 설명합니다."); ?>

<?php $__env->startSection('content'); ?>
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>이용 약관</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    <?php echo e(aiTrans('저희 웹사이트를 방문해 주셔서 감사합니다')); ?> <a href="<?php echo e(route('home', $country)); ?>"> 웹사이트</a> <?php echo e(aiTrans('(이 "웹사이트")에서 이 이용 약관(이 "웹사이트")과 저희의')); ?> <a href="<?php echo e(route('privacy', $country)); ?>"><?php echo e(aiTrans('개인정보 보호정책')); ?></a> <?php echo e(aiTrans('(이 "개인정보 보호정책")을 찾으셨습니다. 이 웹사이트는')); ?> <?php echo e($website_title); ?><?php echo e(aiTrans('가 운영 및 관리하며, 이를 관리하는 모든 모회사, 자회사를 포함한 관계된 모든 회사는')); ?> <?php echo e($website_title); ?>로 언급됩니다. <?php echo e(aiTrans('이 웹사이트는 저희 소유이며 (총칭하여 “저희”, “우리” 또는 “우리의”라고 합니다) 언제든지 이메일을 통해 저희에게 연락하실 수 있습니다')); ?>

                    : <span >info<?php echo e('@'.$website_title); ?></span>
                </p>
                <p>
                    <?php echo e(aiTrans('웹사이트에 접속하거나 저희 제품 및/또는 서비스("공급자 서비스" 및 서비스 가입과 함께 총칭하여 "서비스")를 이용함으로써 귀하는 이 이용 약관("약관")과 저희 개인정보 보호정책을 준수하는 것에 동의합니다. 이 약관에는 운영 규칙, 정책, 정보 및 기타 보충 약관이 포함됩니다. 저희는 언제든지 사전 통지 없이 이 약관을 변경할 권리를 보유합니다. 약관의 업데이트가 게시된 후에 효력이 발생하므로 이 페이지를 주기적으로 확인하는 것이 귀하의 책임입니다. 웹사이트를 계속 사용하는 것은 약관에 대한 동의로 간주됩니다.', $locale)); ?>

                </p>
                <p>
                    <?php echo e(aiTrans('이용 약관을 신중히 검토하십시오. 이 약관의 일부에 동의하지 않으면 서비스 또는 웹사이트를 사용할 수 없습니다. 저희는 전적인 재량에 따라 서비스와/또는 웹사이트의 접근을 거부할 권리를 보유합니다.', $locale)); ?>

                </p>
                <h3><?php echo e(aiTrans('투자 자문 없음', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('명시적으로 달리 명시되지 않는 한, 이 웹사이트는 개인 투자 자문을 제공할 목적으로 설계되지 않았습니다. 제공된 정보는 귀하의 특정 투자 목표, 재정 상황 또는 투자 필요를 고려하지 않습니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('이 웹사이트의 정보가 귀하의 투자 목표, 재정 상황 및 투자 필요에 적합한지 평가해야 합니다. 이 웹사이트에서 제공된 정보를 바탕으로 투자 결정을 내리기 전에 이를 평가해야 합니다. 이 평가를 스스로 할 수 있으며, 독립적인 재정 상담가의 전문가 도움을 받을 수도 있습니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('명시적으로 달리 명시되지 않는 한, 이 웹사이트에 포함된 정보는 IG 그룹의 어떤 회사가 제공하는 금융 제품이나 서비스에 대한 투자 권고가 아닙니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('제품 및 서비스', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('이 웹사이트에서 언급된 모든 제품과 서비스가 반드시 우리가 제공하는 것은 아닙니다. 제3자 제품, 서비스, 웹사이트 또는 네트워크를 식별하거나 사용하는 것은 해당 제품, 서비스, 웹사이트 또는 네트워크에 대한 권고를 의미하지 않습니다. 이 웹사이트는 귀하가 하이퍼링크나 다른 링크를 통해 저희가 아닌 다른 사람이 제공하는 웹사이트 및 네트워크에 액세스할 수 있도록 할 수 있습니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('저희는 저희의 직접적인 제어를 벗어난 웹사이트나 네트워크에서의 어떤 자료에 대해서도 책임을 지지 않습니다. 귀하는 해당 링크를 통해 다른 웹사이트나 네트워크에 접근함으로써 해당 웹사이트나 네트워크의 소유자에게 귀하에 대한 특정 정보를 제공해야 할 수도 있음을 인지합니다. 이 웹사이트에 있는 어떠한 내용도 저희의 투자 또는 재정 자문이 아니며, 그렇게 해석되어서는 안 됩니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('범위 및 수정', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('귀하는 본 문서에 명시된 약관에 동의함으로써 웹사이트 사용에 동의합니다. 이 약관은 귀하와 저희 간의 완전한 계약을 구성하며, 웹사이트와 관련된 이전의 모든 계약, 진술, 보장 및 이해를 대체합니다.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('이 약관은 주기적으로 변경될 수 있습니다. 저희는 이 약관을 변경할 경우 해당 변경 사항에 대해 귀하에게 알려드리며, 또한 변경 사항을 게시할 것입니다. 웹사이트 및/또는 서비스의 지속적인 사용은 변경된 약관을 수락하는 것으로 간주됩니다. 이 페이지를 주기적으로 확인하는 것은 귀하의 책임입니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('요구 사항', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트와 저희 서비스는 적용 가능한 법률에 따라 법적 구속력이 있는 계약을 체결할 수 있는 자격이 있는 개인만 사용할 수 있습니다. 18세 미만의 개인은 이 웹사이트 및/또는 서비스를 사용할 수 없습니다. 귀하가 18세 미만인 경우, 웹사이트 및/또는 서비스에 접근하거나 이를 사용할 수 없습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('서비스 설명', $locale)); ?></h3>
<p>
    <i><?php echo e(aiTrans('구독 서비스:', $locale)); ?></i> <?php echo e(aiTrans('웹사이트에 등록하고 저희의 승인을 받은 후, 귀하는 유료 또는 무료로 구독 서비스를 이용할 수 있습니다. 이 서비스는 온라인 마케팅을 위해 저희와 제3자 파트너("제공업체")의 관련 이메일, 문자 및 기타 자료("구독 콘텐츠")를 제공합니다. 이는 투자 자문이 아닙니다. 귀하는 구독 콘텐츠의 정확성, 완전성 또는 적합성에 대해 저희가 책임지지 않는다는 것에 동의합니다.', $locale)); ?>

</p>
<p>
    <i><?php echo e(aiTrans('제공업체 및 제3자 서비스:', $locale)); ?></i> <?php echo e(aiTrans('등록 양식을 작성하여 웹사이트에서 특정 제품 및/또는 서비스를 제공받거나 제공받을 수 있습니다. 웹사이트에 제공된 제품 및/또는 서비스 설명은 제3자 제공업체가 제공할 수 있습니다. 저희는 그러한 설명의 정확성이나 완전성을 보장하지 않습니다. 귀하는 웹사이트나 제휴된 파트너로부터 제품 및/또는 서비스를 받지 못하거나 제품 판매자, 유통업체, 제3자 제공업체와의 분쟁에 대해 저희가 책임지지 않는다는 것에 동의합니다.', $locale)); ?>

</p>
<p>
    <i><?php echo e(aiTrans('일반:', $locale)); ?></i> <?php echo e(aiTrans('서비스를 사용하려면 정확한 서비스 등록 데이터를 제공해야 하며, 저희는 불완전하거나 사기성 데이터 또는 수락할 수 없는 데이터를 거부할 권리를 보유합니다. 다른 방법으로 명시되지 않는 한, 웹사이트 기능 향상을 위한 향후 제공은 본 약관을 따릅니다. 귀하는 서비스 이용 또는 자격 부족으로 발생하는 문제에 대해 저희가 책임지지 않는다는 것에 동의합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('소유권', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트, 콘텐츠 및 서비스, 조직, 그래픽, 디자인, 컴파일, 소프트웨어 및 기타 관련 사항은 저작권, 상표 및 기타 적용 가능한 지적 재산권으로 보호됩니다. 웹사이트, 콘텐츠 및/또는 서비스의 일부를 복제, 재배포하거나 판매하는 것은 엄격히 금지됩니다. 자동화된 방법 또는 스크래핑을 통해 자료를 취득하는 것은 서면 허가 없이 금지됩니다. 귀하는 웹사이트에 있는 어떤 콘텐츠, 문서, 소프트웨어, 서비스 또는 자료에 대한 소유권을 취득하지 않습니다. 저희의 이름, 로고, 그래픽, 아이콘 및 서비스 이름은 상표입니다. 허가 없이 상표를 사용하는 것은 엄격히 금지됩니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('기밀 정보', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('기밀 정보는 명시적으로 기밀로 식별된 정보를 말하며, 공개된 정보, 기존 지식, 독립적으로 개발된 정보 또는 제3자로부터 제공된 제한이 없는 정보를 제외합니다. 기밀 정보를 보호할 의무는 종료 후 1년 동안 유지됩니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('웹사이트에 대한 하이퍼링크, 공동 브랜드, "프레임" 또는 웹사이트 참조 금지', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('저희의 명시적인 허가 없이 웹사이트 또는 그 일부에 대한 하이퍼링크를 다른 웹사이트에서 연결하는 것은 금지됩니다. 웹사이트를 "프레임"하거나 "URL"을 참조하는 것은 서면 허가 없이 엄격히 금지됩니다. 이러한 콘텐츠나 활동을 제거하는 협력이 의무이며, 귀하는 이에 따른 손해에 대해 책임을 집니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('편집, 삭제 및 수정', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('우리는 웹사이트에서 문서, 정보 또는 콘텐츠를 사전 통지 없이 편집 및/또는 삭제할 권리를 보유합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('책임의 면책', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트, 서비스, 콘텐츠 및 제3자 제품은 "있는 그대로"와 "사용 가능한 대로" 제공되며, 적용 가능한 법률이 허용하는 한 최대 범위에서 모든 명시적 및 암시적 보증을 제외합니다. 우리는 웹사이트, 서비스, 콘텐츠 및/또는 제3자 제품이 귀하의 요구를 충족하거나 중단 없이 제공되거나 오류가 없음을 보장하지 않습니다. 귀하는 웹사이트, 서비스, 콘텐츠 및/또는 제3자 제품을 사용하지 못한 것과 관련된 어떤 클레임에 대해서도 저희가 책임지지 않음을 동의합니다. 웹사이트에는 버그, 오류 또는 제한이 있을 수 있으며, 우리는 인터넷 연결의 가용성에 대해서도 책임지지 않습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('책임의 제한', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('우리는 직접적, 간접적, 우발적, 특수 또는 예시적인 손해, 이익 손실, 신뢰 손실, 사용, 데이터 또는 기타 무형 손실에 대해 책임지지 않습니다. 이 제한은 계약 위반, 보증, 과실, 객관적 책임, 허위 진술 및 기타 모든 불법 행위에 적용됩니다. 귀하는 저희와 제3자 공급업체에 대해 제한된 책임 이상으로 어떠한 의무, 책임 또는 클레임도 면제하는 것에 동의합니다. 적용 가능한 법률이 이 제한을 허용하지 않는 경우, 저희의 최대 책임은 500달러($500.00)로 한정됩니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('배상', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('귀하는 웹사이트, 서비스 또는 콘텐츠 사용과 관련된 클레임, 비용, 손해, 소송, 비용, 요구 사항 및/또는 제3자에 의해 제기된 판결에 대해 저희와 저희의 파트너, 자회사, 계열사 및 그들의 구성원, 이사, 직원, 대리인 및 파트너를 배상하고 면책합니다; 이 약관의 위반; 그리고/또는 다른 개인 및/또는 엔터티의 권리 위반과 관련하여 발생하는 모든 클레임에 대해 배상합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('제3자 웹사이트', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트는 제3자 제공업체가 소유한 다른 웹사이트 및/또는 리소스에 대한 링크를 제공할 수 있습니다. 우리는 이러한 제3자 웹사이트 및/또는 리소스의 가용성에 대해 책임지지 않으며, 그들의 콘텐츠에 대해서도 책임을 지지 않습니다. 또한 그들의 조건, 개인정보 보호정책, 콘텐츠, 광고, 서비스, 제품 또는 자료에 대해서도 책임을 지지 않습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('개인정보 보호정책/방문자 정보', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('귀하의 웹사이트 사용과 모든 댓글, 피드백, 정보, 등록 데이터 및/또는 제출된 자료는 저희의 개인정보 보호정책의 적용을 받습니다. 우리는 귀하의 웹사이트 사용에 관한 정보와 개인 식별 가능한 정보를 저희 개인정보 보호정책과 적용 가능한 데이터 보호 법률에 따라 사용할 권리를 보유합니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('법적 경고', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('웹사이트의 운영을 손상시키거나 파괴하거나 변조하거나 훼손하거나 방해하려는 모든 시도는 형사 및 민사 법을 위반하는 것입니다. 우리는 법률과 공정에 따라 모든 위반자에 대해 구제책을 추구할 것입니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('법률 선택 및 관할권', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('이 약관은 영국 법에 의해 지배되고 해석됩니다. 당사자는 이 약관과 관련된 모든 클레임 또는 분쟁을 원만하게 해결하기 위해 선의로 협상하려고 시도해야 합니다. 당사자가 합의에 도달하지 못할 경우, 분쟁은 런던에서 ICC 규칙에 따라 단독 중재자 앞에서 비공개로 진행되며, 판결은 최종적이고 구속력이 있습니다. 어느 한 쪽도 본인의 거주지 또는 다른 법원에 클레임을 제기할 수 없습니다.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('데이터 보호 부속서', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('이 데이터 보호 부속서는 저희의 이용 약관의 일부입니다. 이 부속서에서 사용되는 용어는 이 부속서에 명시된 의미를 가집니다. 아래에서 수정된 사항을 제외하고, 약관은 여전히 유효하며 효력을 가집니다.', $locale)); ?>

</p>
<ol class="nested-list">
    <li>
        <b><?php echo e(aiTrans('정의', $locale)); ?></b>
        <ol class="nested-list">
            <li>
                <b><?php echo e(aiTrans('적용 법률:', $locale)); ?></b> <?php echo e(aiTrans('개인 데이터에 대한 EU 법률 또는 데이터 보호 법률에 따른 EU 법률 및 다른 국가의 개인 데이터에 대한 데이터 보호 법률.', $locale)); ?>

            </li>
            <li>
                <b><?php echo e(aiTrans('제어자:', $locale)); ?></b> <?php echo e(aiTrans('개인 데이터 처리의 목적과 방법을 결정하는 엔터티.', $locale)); ?>

            </li>
            <li>
                <b><?php echo e(aiTrans('데이터 보호 법률:', $locale)); ?></b> <?php echo e(aiTrans('EU 데이터 보호 법률 및 다른 국가의 데이터 보호 또는 개인정보 보호 법률.', $locale)); ?>

            </li>
            <li>
                <b><?php echo e(aiTrans('EU 데이터 보호 법률:', $locale)); ?></b> <?php echo e(aiTrans('EU의 95/46/EC 지침, GDPR 및 관련 법률.', $locale)); ?>

            </li>
            <li>
                <b><?php echo e(aiTrans('GDPR:', $locale)); ?></b> <?php echo e(aiTrans('EU의 일반 데이터 보호 규정 2016/679.', $locale)); ?>

            </li>
        </ol>
    </li>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('개인 데이터 수집 및 처리', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('우리는 개인 데이터 처리에 적용 가능한 모든 데이터 보호 법률을 준수할 것에 동의합니다.', $locale)); ?>

                                <ol class="nested-list">
                                    <li>
                                        <?php echo e(aiTrans('우리는 데이터 주체로부터 필요한 허가와 동의를 받아 개인 데이터의 수집, 처리 및 공유를 법적으로 허용한다고 선언하고 보장합니다.', $locale)); ?>

                                    </li>
                                    <li>
                                        <?php echo e(aiTrans('우리는 법률에 따라 동의를 얻고 철회할 수 있는 메커니즘을 유지하며, 공개된 개인정보 보호정책을 제공합니다.', $locale)); ?>

                                    </li>
                                    <li>
                                        <?php echo e(aiTrans('우리는 18세 미만 어린이에게 서비스를 제공하지 않는다고 인식합니다.', $locale)); ?>

                                    </li>
                                </ol>
                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('보안', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('우리는 GDPR 제32조(1)에 따라 데이터 보안을 위한 적절한 기술적 및 조직적 조치를 구현할 것입니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('하위 처리', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('귀하는 저희가 하위 처리자를 지정할 수 있도록 허용하며, 하위 처리자와의 계약이 이 부속서에 설명된 것처럼 개인 데이터에 대한 동일한 보호 수준을 제공하고 GDPR 요구 사항을 충족하는지 확인합니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('데이터 주체의 권리', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('우리는 데이터 주체의 권리 요청에 따라 데이터 보호 법률을 준수하며, 처리의 성격을 고려하여 응답할 것입니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('개인 데이터 침해', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('개인 데이터 침해를 인지한 즉시 영향을 받는 데이터 주체에게 알리고, 조사, 완화 및 수정 작업을 지원합니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('일반 조건', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('이 약관에서 발생하는 분쟁이나 클레임은 이곳에 명시된 법적 관할권에 따릅니다. 어떤 조항이 무효가 되더라도 나머지는 유효합니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                    <li>
                        <b><?php echo e(aiTrans('변경', $locale)); ?></b>
                        <ol class="nested-list">
                            <li>
                                <?php echo e(aiTrans('이 약관은 저희의 전적인 재량에 따라 주기적으로 변경될 수 있습니다.', $locale)); ?>

                            </li>
                        </ol>
                    </li>
                </ol>
                <p>
                    <?php echo e(aiTrans('이 이용 약관에 동의함으로써 귀하는 위에 설명된 모든 약관을 읽고 이해했으며 이에 동의함을 인정합니다. 웹사이트 및 서비스를 계속 사용하면 이 약관을 수락하는 것으로 간주됩니다. 궁금한 점이나 우려 사항이 있으시면 다음 이메일로 저희에게 연락해 주세요:')); ?> <span >info<?php echo e('@'.$website_title); ?></span>
                </p>
                <script>
                    const emails = document.getElementsByClassName('email');
                    for (const email of emails) {
                        email.innerText = `info@${location.hostname}`;
                    }
                </script>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/mb/public_html/allone.crizymp.xyz/resources/views/frontend/ko/terms.blade.php ENDPATH**/ ?>