@extends('layouts.app')
@section('title', $website_title .' | Villkor och Bestämmelser')
@php( $meta_description = "Läs villkoren för ". $website_title.". Våra villkor förklarar dina rättigheter, ansvar och hur du använder våra tjänster på ett säkert och effektivt sätt.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>VILLKOR OCH BESTÄMMELSER</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Tack för att du besöker vår')}} <a href="{{ route('home', $country) }}">webbplats</a> {{aiTrans('(den “Webbplatsen”) där du hittar länken till dessa Villkor och Bestämmelser (den “Webbplatsen”), och vår')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Integritetspolicy')}}</a> {{aiTrans('(den "Integritetspolicyn"). Denna webbplats drivs och kontrolleras av')}} {{ $website_title }}{{aiTrans(' och alla moderbolag, dotterbolag eller relaterade enheter, alla refererade som')}} {{ $website_title }}. {{aiTrans('Webbplatsen är vår ägodel
                    (kollektivt kallad “vi”, “vår” eller “oss”) och du kan kontakta oss när som helst via e-post')}}
                    för: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Genom att få åtkomst till Webbplatsen eller använda våra produkter och/eller tjänster ("Leverantörens Tjänster" och tillsammans med Prenumerationstjänsterna, kallade "Tjänster"), samtycker du till att följa dessa Användarvillkor ("Villkor") och vår Integritetspolicy. Dessa Villkor inkluderar driftsregler, policyer, information och andra kompletterande villkor. Vi förbehåller oss rätten att ändra Villkoren från tid till annan utan föregående meddelande och efter eget gottfinnande. Det är ditt ansvar att regelbundet granska denna sida för uppdateringar av Villkoren, som träder i kraft efter publicering. Din fortsatta användning av Webbplatsen kommer att betraktas som godkännande av Villkoren.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Vänligen granska noggrant de fullständiga villkoren i dessa Villkor och Bestämmelser. Om du inte godkänner någon del av dem, har du inte rätt att använda Tjänsterna eller Webbplatsen på något sätt. Vi förbehåller oss rätten att neka åtkomst till Tjänsterna och/eller Webbplatsen efter eget gottfinnande.', $locale) }}
                </p>
                <h3>{{ aiTrans('INGEN INVESTERINGSRÅDGIVNING', $locale) }}</h3>
<p>
    {{ aiTrans('Om det inte uttryckligen anges annorlunda, har denna webbplats inte utformats för att ge finansiell eller investeringsrådgivning. Informationen som tillhandahålls tar inte hänsyn till dina specifika investeringsmål, din ekonomiska situation eller dina investeringsbehov.', $locale) }}
</p>
<p>
    {{ aiTrans('Du bör bedöma om informationen på denna webbplats är lämplig för dina investeringsmål, ekonomiska situation och investeringsbehov. Du bör göra detta innan du fattar ett investeringsbeslut baserat på informationen som tillhandahålls på denna webbplats. Du kan göra denna bedömning på egen hand eller söka professionell hjälp från en oberoende finansiell rådgivare.', $locale) }}
</p>
<p>
    {{ aiTrans('Om det inte uttryckligen anges annorlunda, utgör informationen som finns på denna webbplats inte en rekommendation om investeringar i några produkter eller finansiella tjänster som erbjuds av någon medlem i IG-gruppens företag.', $locale) }}
</p>
<h3>{{ aiTrans('PRODUKTER OCH TJÄNSTER', $locale) }}</h3>
<p>
    {{ aiTrans('Inte alla produkter och tjänster som nämns på denna webbplats tillhandahålls nödvändigtvis av oss. Identifiering eller användning av produkter, tjänster, webbplatser eller nätverk från tredje part utgör inte en rekommendation av dessa produkter, tjänster, webbplatser eller nätverk. Denna webbplats kan göra det möjligt för dig att komma åt webbplatser och nätverk tillhandahållna av andra än oss via en hyperlänk eller annan länk.', $locale) }}
</p>
<p>
    {{ aiTrans('Vi accepterar inte något ansvar för material på någon webbplats eller nätverk som inte är under vår direkt kontroll. Du erkänner att din åtkomst till dessa andra webbplatser eller nätverk via en sådan länk kan kräva att vi tillhandahåller viss information om dig till ägaren av den webbplatsen eller nätverket. Inget på denna webbplats är tänkt att vara eller bör tolkas som investeringsrådgivning från oss eller genom oss.', $locale) }}
</p>
<h3>{{ aiTrans('OMFATTNING OCH ÄNDRING', $locale) }}</h3>
<p>
    {{ aiTrans('Du godkänner villkoren som beskrivs i detta dokument avseende användning av vår Webbplats. Dessa Villkor utgör det fullständiga avtalet mellan dig och oss och ersätter alla tidigare avtal, representationer, garantier och förståelser rörande Webbplatsen.', $locale) }}
</p>
<p>
    {{ aiTrans('Observera att dessa Villkor kan ändras periodvis. Om vi ändrar dessa Villkor kommer vi att informera dig om de alternativ som finns tillgängliga till följd av sådana förändringar. Dessutom kommer vi att publicera ett meddelande som anger ändringen. Fortsatt användning av Webbplatsen och/eller våra Tjänster innebär att du samtycker till att följa de uppdaterade villkoren som gäller vid den tidpunkten. Det är ditt ansvar att regelbundet kontrollera denna sida för uppdateringar och/eller ändringar.', $locale) }}
</p>
<h3>{{ aiTrans('KRAV', $locale) }}</h3>
<p>
    {{ aiTrans('Webbplatsen och våra Tjänster är endast tillgängliga för individer som är berättigade att ingå rättsligt bindande avtal enligt tillämplig lag. De är inte avsedda för användning av individer under arton (18) år. Om du är under arton (18) år, har du inte rätt att använda och/eller få tillgång till Webbplatsen och/eller Tjänsterna.', $locale) }}
</p>
<h3>{{ aiTrans('BESKRIVNING AV TJÄNSTER', $locale) }}</h3>
<p>
    <i>{{ aiTrans('Prenumerationstjänster:', $locale) }}</i> {{ aiTrans('Genom att registrera dig på Webbplatsen och få vårt godkännande kan du få, eller försöka få, Prenumerationstjänster mot en avgift eller utan avgift. Dessa tjänster tillhandahåller e-postinnehåll, text och annat material ("Prenumerationsinnehåll") relevant för online marknadsföring från oss och tredjeparts partners ("Tredjepartsleverantörer"). Detta är inte investeringsrådgivning. Du förstår och godkänner att vi inte är ansvariga för eller ansvariga för riktigheten, fullständigheten eller lämpligheten av Prenumerationsinnehållet.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Tjänster från Leverantör och Tredje part:', $locale) }}</i> {{ aiTrans('Genom att fylla i registreringsformulär kan du få, eller försöka få, vissa produkter och/eller tjänster från Webbplatsen. Produkt- och/eller tjänstbeskrivningar på Webbplatsen kan tillhandahållas av Tredjepartsleverantörer. Vi garanterar inte riktigheten eller fullständigheten av sådana beskrivningar. Du förstår och godkänner att vi inte är ansvariga för din oförmåga att få produkter och/eller tjänster från Webbplatsen eller dess partners, eller för några tvister med försäljare av produkter, distributörer, tredjepartsleverantörer med vilka du kan interagera i relation till webbplatsen.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Allmänt:', $locale) }}</i> {{ aiTrans('För att använda Tjänsterna måste du tillhandahålla korrekt Registreringsinformation, och vi förbehåller oss rätten att avvisa ofullständiga, falska eller oacceptabla uppgifter. Om inte uttryckligen angivet på annat sätt kommer framtida erbjudanden som förbättrar funktionerna på Webbplatsen att omfattas av dessa Villkor. Du godkänner att vi inte är ansvariga för din oförmåga att använda och/eller kvalificera dig för Tjänsterna och för eventuella ändringar, uppsägningar eller nedläggningar.', $locale) }}
</p>
<h3>{{ aiTrans('EGENSKAPSRÄTTIGHETER', $locale) }}</h3>
<p>
    {{ aiTrans('Webbplatsen, Innehållet och Tjänsterna, inklusive organisation, grafik, design, sammanställning, programvara och andra ämnen, är skyddade av upphovsrätt, varumärken och andra tillämpliga egendomsrättigheter. Återgivning, omfördelning eller försäljning av någon del av Webbplatsen, Innehåll och/eller Tjänster är strikt förbjudet. Återvinning av material genom automatiserade medel eller skrapning för något ändamål utan skriftligt tillstånd är förbjudet. Du får inte förvärva äganderätt till något innehåll, dokument, programvara, tjänster eller material på Webbplatsen. Vårt namn, logotyp, grafik, ikoner och tjänstnamn är varumärken. Obearbetad användning av något varumärke är strikt förbjudet.', $locale) }}
</p>
<h3>{{ aiTrans('KONFIDENTIELL INFORMATION', $locale) }}</h3>
<p>
    {{ aiTrans('Konfidentiell information hänvisar till äganderättsinformation som identifieras som sådan och undantar information som är offentligt känd, tidigare känd kunskap, information som utvecklats självständigt eller information som tas emot från tredje part utan några sekretessbegränsningar. Skyldigheten att skydda konfidentiell information upphör ett (1) år efter avslutande.', $locale) }}
</p>
<h3>{{ aiTrans('FÖRBUD MOT HYPERLÄNKAR TILL WEBBPLATSEN, CO-BRANDING, "FRAMING" OCH/ELLER REFERENS TILL WEBBPLATSEN', $locale) }}</h3>
<p>
    {{ aiTrans('Hyperlänkar till Webbplatsen eller delar av den på en annan webbplats utan vårt uttryckliga godkännande är förbjudet. "Framing" av Webbplatsen eller att referera till Uniform Resource Locator ("URL") utan vårt skriftliga tillstånd är strikt förbjudet. Samarbete för att ta bort sådant innehåll eller aktivitet är obligatoriskt, och du är ansvarig för eventuella skador som uppstår.', $locale) }}
</p>
<h3>{{ aiTrans('REDIGERING, RADERING OCH ÄNDRING', $locale) }}</h3>
<p>
    {{ aiTrans('Vi förbehåller oss rätten att redigera och/eller radera dokument, information eller innehåll på Webbplatsen utan föregående meddelande.', $locale) }}
</p>
<h3>{{ aiTrans('ANSVARSFRISKRIVNING', $locale) }}</h3>
<p>
    {{ aiTrans('WEBBPLATSEN, TJÄNSTER, INNEHÅLL OCH EVENTUELLA PRODUKTER FRÅN TREDJE PART TILLHANDAHÅLLS "SOM DE ÄR" OCH "ENLIGT TILLGÄNGLIGHET", MED ALLA GARANTIER, UTTRYCKLIGA OCH IMPLICTA, UTMEDLADE I DEN MAKSIMALA UTSTRÄCKNING SOM TILLÅTS ENLIGT TILLÄMPLIG LAG. VI GARANTERAR INTE ATT WEBBPLATSEN, TJÄNSTER, INNEHÅLL OCH/ELLER PRODUKTER FRÅN TREDJE PART KOMMER ATT UPPFYLLA DINA KRAV ELLER KOMMER ATT VARA OAVBRUTNA, TIDSENLIGA, SÄKRA ELLER FRI FRÅN FEL. DU GODKÄNNER ATT VI INTE ÄR ANSVARIGA FÖR NÅGON KRAV RELATERAD TILL OFÖRMÅGA ATT ANVÄNDA WEBBPLATSEN, TJÄNSTER, INNEHÅLL OCH/ELLER PRODUKTER FRÅN TREDJE PART. WEBBPLATSEN KAN INNEHÅLLA FEL, BUGGAR ELLER BEGRÄNSNINGAR, OCH VI ÄR INTE ANSVARIGA FÖR INTERNETANSLUTNINGENS TILLGÄNGLIGHET.', $locale) }}
</p>
<h3>{{ aiTrans('ANSVARSBEGRÄNSNING', $locale) }}</h3>
<p>
    {{ aiTrans('VI ÄR INTE ANSVARIGA FÖR DIREKTA, INDIREKTA, OLYCKSBILDA, SPECIELLA ELLER EXEMPLARISKA SKADOR, INKLUSIVE FÖRLUST AV VINST, GOD VILJA, ANVÄNDNING, DATA ELLER ANDRA OBEHAGLIGA FÖRLUSTER. DENNA BEGRÄNSNING TILLÄMPAS PÅ ALLA ORSAKER TILL ÅTGÄRDER, INKLUSIVE BROTT AV KONTRAKT, GARANTI, VÅRDSLÖSHET, OBJEKTIVT ANSVAR, FALSKA UTTALANDEN OCH ANDRA BROTT. DU FRIGÖR OSS OCH VÅRA TREDJEPARTSFÖRSEDARE FRÅN SKYLDIGHETER, ANSVAR OCH KRAV BEYOND DEN BEGRÄNSNING SOM INDIKERAS. OM TILLÄMPLIG LAG INTE TILLÅTER DENNA BEGRÄNSNING, KOMMER VÅRT MAKSIMALA ANSVAR UNDER NÅGON OMSTÄNDIGHET ATT VARA FEM HUNDRA DOLLAR ($500,00).', $locale) }}
</p>
<h3>{{ aiTrans('ERSÄTTNING', $locale) }}</h3>
<p>
    {{ aiTrans('Du samtycker till att ersätta och hålla oss, våra partners, dotterbolag, affilierade och deras respektive medlemmar, direktörer, anställda, agenter och partners fria från alla krav, utgifter, skador, processer, kostnader, krav och/eller domar som görs av tredje part på grund av eller som resultat av din användning av Webbplatsen, Tjänster eller Innehåll; ditt brott mot dessa Villkor; och/eller din överträdelse av rättigheterna för annan individ och/eller enhet.', $locale) }}
</p>
<h3>{{ aiTrans('WEBBPLATSER FRÅN TREDJE PART', $locale) }}</h3>
<p>
    {{ aiTrans('Webbplatsen kan tillhandahålla länkar till andra webbplatser och/eller resurser från Internet som tillhör Tredjepartsleverantörer. Vi ansvarar inte för tillgängligheten av sådana webbplatser och/eller resurser från tredje part, eller deras innehåll, och vi godkänner eller åtar oss inget ansvar för deras villkor, sekretesspolicyer, innehåll, annonsering, tjänster, produkter eller material.', $locale) }}
</p>
<h3>{{ aiTrans('INTEGRITETSPOLICY/INFORMATION OM BESÖKARE', $locale) }}</h3>
<p>
    {{ aiTrans('Din användning av Webbplatsen och alla kommentarer, feedback, information, registreringsdata och/eller material som skickas in är föremål för vår Integritetspolicy. Vi förbehåller oss rätten att använda information om din användning av Webbplatsen och personligt identifierbar information i enlighet med vår Integritetspolicy och de tillämpliga dataskyddslagarna.', $locale) }}
</p>
<h3>{{ aiTrans('JURIDISK VARNING', $locale) }}</h3>
<p>
    {{ aiTrans('Alla försök att skada, förstöra, manipulera, vandalisera eller störa Webbplatsens drift är ett brott mot straff- och civilrätt. Vi kommer att vidta åtgärder mot alla individer eller enheter som bryter mot lagen i maximal utsträckning enligt lag och rättvisa.', $locale) }}
</p>
<h3>{{ aiTrans('VAL AV LAG OCH DOMSTOL', $locale) }}</h3>
<p>
    {{ aiTrans('Dessa Villkor styrs och tolkas i enlighet med lagarna i Storbritannien. Parterna ska försöka förhandla fram en lösning i god tro för alla krav eller tvister som uppstår eller är relaterade till dessa Villkor och Bestämmelser på ett vänskapligt sätt. Om parterna inte kommer överens, ska tvisten exklusivt hänskjutas till konfidentiell skiljedom framför en enda skiljedomare i London, enligt ICC:s regler, vars dom ska vara slutgiltig och bindande. Ingen part får framställa ett krav inför den lokala domstolen i sitt hemvist eller någon annan domstol.', $locale) }}
</p>
<h3>{{ aiTrans('BILAGA FÖR DATASKYDD', $locale) }}</h3>
<p>
    {{ aiTrans('Detta Dataskyddsbilaga är en del av våra Villkor och Bestämmelser. Termerna som används här har specifika betydelser som anges i denna Bilaga. Förutom vad som ändras nedan, förblir Villkoren i full kraft och effekt.', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Definitioner', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('Tillämpliga Lagar:', $locale) }}</b> {{ aiTrans('EU:s lagar eller medlemsstatens lagar om Personuppgifter som omfattas av EU:s Dataskyddsreglering och andra tillämpliga lagar för Personuppgifter som omfattas av andra Dataskyddslagar.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Personuppgiftsansvarig:', $locale) }}</b> {{ aiTrans('Enhet som bestämmer syftet med och medlen för behandling av Personuppgifter.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Dataskyddslagar:', $locale) }}</b> {{ aiTrans('EU:s dataskyddslagar och dataskydds- eller sekretesslagar från något annat land.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('EU:s Dataskyddslagar:', $locale) }}</b> {{ aiTrans('Direktiv 95/46/EG från EU, GDPR och relaterade lagar.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('EU:s Allmänna dataskyddsförordning 2016/679.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Insamling och Behandling av Personuppgifter', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('Vi åtar oss att följa alla tillämpliga dataskyddslagar vid behandling av Personuppgifter.', $locale) }}
                <ol class="nested-list">
                    <li>
                        {{ aiTrans('Vi deklarerar och garanterar att vi har de nödvändiga tillstånden och samtyckena från de registrerade för att lagligt tillåta insamling, behandling och delning av Personuppgifter via Tjänsterna enligt Tillämpliga Lagar.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('Vi kommer att upprätthålla en mekanism för att erhålla och återkalla samtycke, i enlighet med Tillämpliga Lagar, och en offentlig tillgänglig sekretesspolicy.', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('Vi erkänner att vi inte tillhandahåller Tjänster till barn under arton (18) år.', $locale) }}
                    </li>
                </ol>
            </li>
        </ol>
    </li>
<li>
    <b>{{ aiTrans('Säkerhet', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Vi kommer att implementera lämpliga tekniska och organisatoriska åtgärder för dataskydd i enlighet med artikel 32(1) i GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Underleverantörer', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Du ger oss tillstånd att utse Underleverantörer och säkerställa att skriftliga avtal med Underleverantörer erbjuder samma skyddsnivå för Personuppgifter som beskrivs i denna Bilaga och uppfyller GDPR:s krav.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Registrerades Rättigheter', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Vi kommer att hjälpa till att svara på begäran om rättigheter från registrerade enligt dataskyddslagar, med hänsyn till behandlingens natur.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Personuppgiftsincidenter', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Vi kommer omedelbart att informera de registrerade som berörs när vi får kännedom om en Personuppgiftsincident, och hjälpa till med undersökning, åtgärder och åtgärder för att åtgärda den.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Allmänna Villkor', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Tvister eller krav som uppstår från dessa Villkor är underkastade den jurisdiktion som här anges. Om någon bestämmelse är ogiltig, förblir resten giltigt.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Ändringar', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Ändringar i dessa Villkor kan göras från tid till annan enligt vårt eget gottfinnande.', $locale) }}
        </li>
    </ol>
</li>
</ol>
<p>
    {{ aiTrans('Genom att godkänna dessa Villkor erkänner du att du har läst, förstått och samtycker till att vara bunden av alla de villkor som beskrivs ovan. Din fortsatta användning av Webbplatsen och Tjänsterna innebär godkännande av dessa villkor. Om du har några frågor eller funderingar, vänligen kontakta oss via') }} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>


            </div>
        </div>
    </div>
@endsection
