@extends('layouts.app')
@section('title', $website_title .' | Zásady ochrany osobných údajov')
@php( $meta_description = "Zistite, ako [website_title] chráni vaše osobné údaje. Naša politika ochrany osobných údajov podrobne popisuje opatrenia, ktoré prijímame na zabezpečenie bezpečnosti a transparentnosti vašich informácií.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>ZÁSADY OCHRANY OSOBNÝCH ÚDAJOV</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Úvod', $locale) }}</h3>
<p>
    {{ aiTrans('Toto vyhlásenie popisuje zásady ochrany osobných údajov prijaté spoločnosťou', $locale) }} {{ $website_title }} ("{{ aiTrans('my', $locale) }}," "{{ aiTrans('naša', $locale) }}," "{{ aiTrans('alebo', $locale) }}")
    {{ aiTrans('v súvislosti s našimi produktmi a službami (ďalej len "Služby") a', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('webová stránka', $locale) }}</a>
    {{ aiTrans('(ďalej len "Webová stránka")', $locale) }}. {{ aiTrans('Chrániť vaše súkromie a dôvernosť vašich informácií je pre nás kľúčové pri poskytovaní našich Služieb a prevádzkovaní Webovej stránky.', $locale) }}
</p>
<p>
    {{ aiTrans('Naše Služby a Webová stránka môžu obsahovať odkazy na webové stránky a služby tretích strán. Nezodpovedáme za zásady ochrany osobných údajov týchto tretích strán. Odporúčame vám, aby ste si pred ich použitím preštudovali ich zásady ochrany osobných údajov.', $locale) }}
</p>
<p>
    {{ aiTrans('Všetky informácie získané od nás v súvislosti s našimi Službami sa považujú za dôverné. Používame robustné technické, bezpečnostné a organizačné opatrenia na ochranu osobných údajov (ako je definované nižšie) pred neoprávneným spracovaním, náhodnou stratou, zničením, poškodením, krádežou alebo zverejnením.', $locale) }}
</p>
<p>
    {{ aiTrans('Pri odosielaní vašich informácií prostredníctvom našej webovej stránky môžete byť požiadaní o poskytnutie osobných údajov, ako je vaše meno, e-mail, telefónne číslo, dátum narodenia a rôzne identifikačné údaje. Tieto informácie môžu byť použité na overenie identity, správu informácií, poskytovanie technickej podpory a plnenie zmluvných a právnych povinností. Môžeme komunikovať dôležité detaily prostredníctvom notifikácií a so súhlasom vám poskytnúť informácie o produktoch a službách prostredníctvom SMS, e-mailu atď. Máte možnosť spravovať preferencie notifikácií a odhlásiť sa z určitých komunikácií.', $locale) }}
</p>
<h3>{{ aiTrans('2. Webová stránka; Návštevníci a používatelia', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Všeobecne', $locale) }}</h4>
<p>
    {{ aiTrans('Táto sekcia vyznačuje špecifiká zhromažďovania údajov rôznych skupín: návštevníci webovej stránky ("Návštevníci"), používatelia ("Používatelia") a obchodní partneri (spoločne "Partneri"). Osobné údaje zahŕňajú IP adresu, meno, kontaktné údaje a informácie o vzťahu s nami, ako je definované príslušnými predpismi o ochrane údajov.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Zhromažďovanie a Používanie', $locale) }}</h4>
<p>
    {{ aiTrans('Pri návšteve Webovej stránky súhlasíte so zhromažďovaním a používaním vašich Osobných údajov. Ak nesúhlasíte s týmito podmienkami, mali by ste sa zdržať návštevy Webovej stránky. Môžeme zhromažďovať informácie prostredníctvom aktivity zobrazenia stránok, IP adries a cookies. Okrem toho spracúvame údaje poskytnuté dobrovoľne prostredníctvom formulárov a registrácií.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Účel Spracovania Osobných Údajov', $locale) }}</h4>
<p>
    {{ aiTrans('Spracúvame Osobné údaje na zlepšenie, porozumenie a personalizáciu našich Webových stránok a Služieb. To zahŕňa zlepšenie presnosti, komunikáciu o Službách, podporu, plnenie zmluvných povinností a spoluprácu s partnermi. Súhlas alebo právny základ je nevyhnutný pre akékoľvek spracovanie.', $locale) }}
</p>
<p>{{ aiTrans('Nasledujúce popisuje účely a právny základ spracovania Osobných údajov:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registrácia ako držiteľ účtu', $locale) }}</td>
            <td>{{ aiTrans('Váš súhlas; vykonávanie Služieb alebo zmluvných povinností', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Poskytovanie a používanie Služieb', $locale) }}</td>
            <td>{{ aiTrans('Vykonávanie Služieb alebo zmluvných povinností', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Prevádzkové aktualizácie', $locale) }}</td>
            <td>{{ aiTrans('Vykonávanie Služieb alebo zmluvných povinností', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Odpovedanie na dopyty a poskytovanie podpory', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy alebo vykonávanie Služieb', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Služby, reklama a personalizovaný marketing', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy alebo váš súhlas', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Zlepšenie a ponuka nových Služieb', $locale) }}</td>
            <td>{{ aiTrans('Súhlas a legitímne záujmy', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Posielanie reklamných a marketingových materiálov', $locale) }}</td>
            <td>{{ aiTrans('Váš súhlas', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analýza účinnosti marketingových kampaní', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy alebo súhlas', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Vykonávanie rôznych podporných aktivít', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy alebo vykonávanie Služieb', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analýza, vrátane štatistickej analýzy', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Ochrana záujmov, práv a majetku', $locale) }}</td>
            <td>{{ aiTrans('Legitímne záujmy alebo právne povinnosti', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Zdieľanie Osobných Údajov', $locale) }}</h4>
<p>
    {{ aiTrans('Môžeme zdieľať informácie s poskytovateľmi služieb, Partnermi a dodávateľmi. Pre Návštevníkov a Používateľov v Európskej hospodárskej oblasti je spracovanie údajov v súlade s GDPR a príslušnými predpismi o ochrane údajov.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partneri', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Všeobecne', $locale) }}</h4>
<p>
    {{ aiTrans('Na poskytovanie Služieb a spoluprácu s Partnermi zhromažďujeme a spracúvame konkrétne typy údajov. Partneri sú zodpovední za svoje údaje a môžeme k nim pristupovať bezpečnými prostriedkami.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Spracovanie Osobných Údajov', $locale) }}</h4>
<p>
    {{ aiTrans('Závisíme od súhlasu Partnerov alebo legitímnych záujmov na spracovanie Osobných údajov. Môžu byť vytvorené agregácie údajov na vývoj a zlepšenie kvality.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Správca/Procesor', $locale) }}</h4>
<p>{{ aiTrans('Môžeme pôsobiť ako Správca alebo Procesor, v závislosti od typu údajov:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Údaje o Návštevníkoch/Používateľoch: Správca', $locale) }}</li>
    <li>{{ aiTrans('Údaje o Partneroch: Procesor', $locale) }}</li>
    <li>{{ aiTrans('Všetky údaje sú bezpečne hosťované, v súlade s najvyššími bezpečnostnými štandardmi. Implementujeme fyzické, technické a organizačné ochranné opatrenia.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Ochrana Údajov Tretích Osôb', $locale) }}</h4>
<p>{{ aiTrans('Ak Služby zahŕňajú spracovanie Osobných údajov na platforme tretích strán:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Pôsobíme ako Procesor', $locale) }}</li>
    <li>{{ aiTrans('Plnenie pokynov tretích strán', $locale) }}</li>
    <li>{{ aiTrans('Implementácia bezpečnostných opatrení', $locale) }}</li>
    <li>{{ aiTrans('Oznamovanie porušení údajov', $locale) }}</li>
    <li>{{ aiTrans('Nezadavanie subdodávok bez súhlasu', $locale) }}</li>
    <li>{{ aiTrans('Nezpracovanie údajov mimo Európskeho hospodárskeho priestoru bez súhlasu', $locale) }}</li>
    <li>{{ aiTrans('Pre elektronické marketingové komunikácie zabezpečujeme súhlas a možnosti zrušenia odberu.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Bezpečnosť', $locale) }}</h3>
<p>
    {{ aiTrans('Používame administratívne, organizačné a technické ochranné opatrenia na ochranu Osobných údajov pred neoprávneným prístupom, zverejnením, zmenou, stratou, zneužitím alebo nelegálnym poškodením. Pri zdieľaní údajov s tretími stranami zabezpečujeme, že dodržiavajú rovnaké štandardy ochrany údajov a sú stanovené zmluvné povinnosti na výlučné a bezpečné spracovanie v súlade s touto politikou.', $locale) }}
</p>
<p>
    {{ aiTrans('Ak existuje podozrenie, že bola interakcia s nami ohrozená, Návštevníci, Používatelia alebo Partneri by nás mali okamžite informovať. Je dôležité poznamenať, že napriek našim bezpečnostným opatreniam nemôžeme zaručiť úplnú imunitu proti útokom tretích strán. Používatelia uznávajú inherentné riziká a možné porušenia.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Pozrite si našu', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Politiku Cookies', $locale) }}</a> {{ aiTrans('na podrobné informácie o typoch cookies a sledovacích technológiach používaných na Webovej stránke, dôvody použitia a ako ich prijať alebo odmietnuť.', $locale) }}
</p>
<h3>{{ aiTrans('6. Odkazy na Iné Webové Stránky', $locale) }}</h3>
<p>
    {{ aiTrans('Počas prezerania Webovej stránky môžu Používatelia naraziť na odkazy na externé webové stránky, ktoré sú mimo nášho kontrolného rámca. Nezodpovedáme za obsah ani zásady ochrany osobných údajov týchto stránok. Používateľom odporúčame, aby si pred poskytnutím akýchkoľvek Osobných údajov preštudovali zásady ochrany osobných údajov týchto stránok a služieb tretích strán.', $locale) }}
</p>
<h3>{{ aiTrans('7. Uchovávanie a Vymazanie', $locale) }}</h3>
<p>
    {{ aiTrans('Údaje, vrátane Osobných údajov, nebudú uchovávané dlhšie, než je nevyhnutné. Návštevníci a/alebo Používatelia s aktívnymi účtami sú zodpovední za včasné vymazanie údajov. Po ukončení účtu alebo partnerstva budú Osobné údaje zhromaždené prostredníctvom Webovej stránky a/alebo Služieb vymazané v súlade s platnými právnymi predpismi a našimi internými politikami.', $locale) }}
</p>
<p>
    {{ aiTrans('Odvolanie súhlasu so spracovaním Osobných údajov môže obmedziť prístup k niektorým alebo všetkým požadovaným Službám, bez toho, aby sa vznášali sťažnosti alebo námietky.', $locale) }}
</p>
<h3>{{ aiTrans('8. Vaše Práva', $locale) }}</h3>
<p>{{ aiTrans('Používatelia majú špecifické práva týkajúce sa ich Osobných údajov:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Právo na Prístup', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Potvrdiť, či sú Osobné údaje spracovávané', $locale) }}</li>
    <li>{{ aiTrans('Prístup k Osobným údajom a súvisiacim informáciám', $locale) }}</li>
    <li>{{ aiTrans('Informácie o účeloch spracovania, kategóriách, príjemcoch, dobe uchovávania, právach a existencii profilov', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Právo na Opravu', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Opraviť nepresné Osobné údaje', $locale) }}</li>
    <li>{{ aiTrans('Doplniť neúplné Osobné údaje', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Právo na Vymazanie', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Požiadať o vymazanie Osobných údajov v konkrétnych prípadoch', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Právo na Obmedzenie Spracovania', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Získať obmedzenie spracovania v konkrétnych prípadoch', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Právo na Prenosnosť Údajov', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Prijať Osobné údaje v štruktúrovanom a strojovo čitateľnom formáte', $locale) }}</li>
    <li>{{ aiTrans('Preniesť Osobné údaje inému správcovi', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Právo na Námietku', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Namietať proti spracovaniu na základe legitímnych záujmov alebo priameho marketingu', $locale) }}</li>
    <li>{{ aiTrans('Ukončiť spracovanie, pokiaľ neexistujú presvedčivé a/alebo právne záväzné dôvody', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Právo na Odvolanie Súhlasu', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Odvolať súhlas so spracovaním Osobných údajov kedykoľvek', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Reklamné a Marketingové Materiály', $locale) }}</h3>
<p>
    {{ aiTrans('Súhlas sa získava na používanie Osobných údajov a kontaktných informácií na poskytovanie reklamných a marketingových materiálov. Odvolanie súhlasu je možné zaslaním písomného oznámenia na poskytnutú e-mailovú adresu.', $locale) }}
</p>
<h3>{{ aiTrans('10. Akceptácia tejto Politiky', $locale) }}</h3>
<p>
    {{ aiTrans('Používaním Webovej stránky a/alebo Služieb sa predpokladá, že Návštevníci, Používatelia a/alebo Partneri prečítali a súhlasia s touto Politikou. Akýkoľvek nesúhlas znamená zdržanie sa používania platformy. Vyhradzujeme si právo modifikovať Politiku, a Používateľom sa odporúča pravidelne kontrolovať aktualizácie. Pokračujúce používanie po zmenách znamená akceptáciu.', $locale) }}
</p>
<h3>{{ aiTrans('11. Právna Povinnosť Zverejniť Osobné Údaje', $locale) }}</h3>
<p>
    {{ aiTrans('Osobné údaje môžu byť zverejnené bez predchádzajúceho súhlasu, ak existuje presvedčenie, že je to potrebné na overenie identity, kontaktovanie alebo začatie právnych konaní proti jednotlivcom podozrivým z porušovania práv alebo majetku. Zverejnenie bude vykonané, ak to vyžaduje zákon.', $locale) }}
</p>
<h3>{{ aiTrans('12. Zodpovedná Osoba za Ochranu Údajov', $locale) }}</h3>
            <p>
                Pre otázky týkajúce sa ochrany osobných údajov a ochrany údajov môžete kontaktovať "Zodpovednú osobu za ochranu údajov" prostredníctvom e-mailu <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>

        </div>
    </div>
</div>
@endsection
