@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Революция в криптовалютной торговле: представляем последнее обновление [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Революция в криптовалютной торговле: представляем последнее обновление {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.ru.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Спасибо! Ваше заявление было получено!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Ой! Что-то пошло не так при отправке формы.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Что такое {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Что такое [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "Мы рады сообщить о запуске новой версии [website_title] — окончательной платформы для криптовалютной торговли. С передовыми функциями, передовыми технологиями и дружелюбным интерфейсом, новый [website_title] был разработан, чтобы вывести ваш торговый опыт на новый уровень. Мощное и интуитивно понятное торговое программное обеспечение способно использовать небольшие ценовые различия между различными биржами криптовалют. Затем оно купит криптовалюту по низкой цене и продаст ее по более высокой цене. Конечный результат — небольшие прибыли, которые приводят к большим доходам для пользователя.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Зарегистрироваться сейчас")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Как начать торговать онлайн?')}}</h2>
        <div class="trading-text">{{aiTrans('Онлайн-торговля, базовая покупка и продажа финансовых активов через Интернет, может быть доступна практически любому человеку, независимо от его предыдущего опыта на глобальных финансовых рынках. Хотя начать достаточно просто, если вы планируете быть прибыльным, онлайн-торговля может стать настоящим вызовом. Чтобы начать торговать онлайн, вам понадобится компьютер и надежное интернет-соединение. После регистрации на торговой платформе с хорошей репутацией вы сможете начать торговать, как только ваша учетная запись будет активирована и пополнена. Интересно, что хотя начать торговать легко, добиться успеха как трейдер гораздо сложнее. Существует множество рисков, о которых вам нужно быть осведомленным. Большая часть торговли связана с методическим планированием, точным анализом рынка, пониманием факторов, влияющих на цены активов, а также методом проб и ошибок. Некоторые рынки активов могут быть довольно волатильными, что значительно увеличивает риск потерь, если у вас нет навыков для использования множества прибыльных торговых возможностей, которые может предложить волатильность. Несмотря на эти вызовы, благодаря достижениям в области алгоритмических технологий, торговое программное обеспечение стало проще и точнее, чем когда-либо. Алгоритм приложения будет анализировать рынки для выявления торговых возможностей, и с этой информацией вы сможете принимать более умные торговые решения, основанные на анализе рынка. Таким образом, даже новички могут начать торговать своими любимыми активами онлайн.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Зарегистрироваться сейчас")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - {{$website_title}} это обман?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] это обман?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
<p class="not-scam-text">
    {{ aiTrans(
        "Нет, это не так. [website_title] не обещает гарантированную прибыль от криптовалютной торговли, так как это не автоматизированное торговое программное обеспечение. Приложение — это всего лишь помощник для трейдера. Оно предназначено для того, чтобы помочь инвесторам торговать криптовалютой с уверенностью. Приложение предоставляет информацию на основе реальных данных в режиме реального времени для трейдеров, помогая им принимать быстрые и точные решения при торговле их любимыми криптовалютами онлайн. Кроме того, приложение безопасно и не нарушает личные или финансовые данные своих клиентов.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>
<div class="button-wrapper">
    <a href="#formTop" class="button white w-button">{{aiTrans("ЗАРЕГИСТРИРОВАТЬСЯ СЕЙЧАС")}}</a>
</div>
</div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Как приложение {{$website_title}} улучшает вашу торговлю?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Как приложение [website_title] улучшает вашу торговлю?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Не имеет значения, какой у вас уровень навыков в онлайн-торговле, вы сможете воспользоваться мощными торговыми функциями, которые предоставляет приложение [website_title]. Однако, прежде чем начать, вам нужно понять, как работает программное обеспечение. [website_title] может анализировать рынки с помощью высокотехнологичного алгоритма, который учитывает большие объемы рыночных данных, а также важные технические индикаторы для определения торговых настроек с высокой вероятностью. Вы также сможете настроить параметры через интуитивно понятный интерфейс программы. Просто настройте, как будет работать программное обеспечение в зависимости от вашего уровня навыков, терпимости к рискам и предпочтений. Программное обеспечение позволяет даже начинающим трейдерам начать торговать на рынках, не беспокоясь о том, чтобы ошибиться при анализе рыночных движений и знать, когда входить в сделку. Кроме того, еще одной важной функцией является то, что по мере того как вы развиваетесь как трейдер, вам, возможно, захочется перейти к более практическому подходу. В этом случае программное обеспечение все еще может быть полезным для подтверждения вашего собственного рыночного анализа перед входом в сделку. Даже на более высоком уровне навыков вы все равно можете столкнуться с ситуациями, когда вы будете слишком нервничать или возбуждены, чтобы принимать логичные торговые решения. В таком случае вы можете использовать рыночный анализ, предоставленный приложением. Это поможет вам избежать ошибок, вызванных эмоциями, обеспечивая, что вы входите в сделки, основываясь на данных рыночного анализа. Одно из лучших преимуществ [website_title] заключается в том, что регистрация новой учетной записи абсолютно бесплатна. Зарегистрируйтесь сейчас и начните торговать на рынках.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Откройте бесплатный аккаунт прямо сейчас')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Основные характеристики [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] — это последняя версия нашего мощного торгового приложения, предназначенная для помощи инвесторам в доступе к и максимальном использовании высококачественных торговых возможностей на рынках криптовалют. Наши передовые финансовые технологии объединяют более 15 инструментов технического анализа, чтобы помочь трейдерам определить идеальные моменты для входа и выхода при торговле их любимыми цифровыми валютами онлайн. Новый [website_title] поддерживает более широкий спектр криптовалют, предлагая больше вариантов для торговли. Независимо от того, интересуетесь ли вы биткойном, эфиром или другими популярными криптовалютами, вы можете торговать ими на новом [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Продвинутые торговые алгоритмы" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Продвинутые торговые алгоритмы')}}</h3>
</div>
<div class="features-list-item-text">{{aiTrans('Наши торговые алгоритмы стали более совершенными, чем когда-либо, позволяя вам использовать движения рынка в реальном времени. С помощью сложных алгоритмов машинного обучения [website_title] может анализировать рыночные данные и делать прогнозы о будущих движениях цен, давая вам преимущество в ваших сделках.', $locale , ['website_title' => $website_title])}}</div>
</div>
</div>
<div class="w-col w-col-4 w-col-stack">
    <div class="features-list-item">
        <div class="features-list-item-header">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Улучшенный пользовательский интерфейс" class="features-list-item-header-icon">
            <h3 class="features-list-item-header-title">{{aiTrans('Улучшенный пользовательский интерфейс')}}</h3>
        </div>
        <div class="features-list-item-text">
            {{ aiTrans(
                "Мы полностью переработали наш пользовательский интерфейс, сделав его более интуитивно понятным и удобным в использовании. Независимо от того, новичок вы или опытный трейдер, новый [website_title] будет легко для вас в навигации и использовании.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
    </div>
</div>
<div class="w-col w-col-4 w-col-stack">
    <div class="features-list-item">
        <div class="features-list-item-header">
            <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Улучшенная безопасность" class="features-list-item-header-icon">
            <h3 class="features-list-item-header-title">{{aiTrans('Улучшенная безопасность')}}</h3>
        </div>
        <div class="features-list-item-text">
            {{ aiTrans(
                "Безопасность — наш главный приоритет в [website_title], и новая платформа включает различные передовые функции безопасности для защиты ваших средств и личных данных. Наша платформа защищена с помощью SSL-шифрования и двухфакторной аутентификации, а также использует самые последние протоколы безопасности для защиты ваших данных.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
    </div>
</div>
</div>
<div class="button-wrapper margin-0-auto">
    <a href="#formTop" class="button w-button">{{aiTrans("ЗАРЕГИСТРИРОВАТЬСЯ СЕЙЧАС")}}</a>
</div>
</div>
<div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Как зарегистрироваться с [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Шаг первый')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Регистрация')}}</h3>
</div>
<div>
    {{ aiTrans(
        "Первый шаг — это заполнить форму регистрации, которую вы найдете на нашем сайте. Вам нужно будет предоставить основные данные, такие как ваше имя, фамилия, адрес электронной почты и номер телефона. После получения письма с подтверждением и перехода по ссылке подтверждения, вы будете зарегистрированы, и ваша новая учетная запись будет активирована. Это означает, что у вас будет полный доступ к торговому приложению [website_title].",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>
</div>
</div>
<div class="col w-col w-col-4 w-col-stack">
    <div class="step-item">
        <div class="step-header">
            <div class="step-header-line-wrapper">
                <div class="step-header-line-text">{{aiTrans('Шаг второй')}}</div>
                <div class="step-header-line"></div>
            </div>
            <h3 class="step-header-line-title">{{aiTrans('Финансирование')}}</h3>
        </div>
        <div>
            {{ aiTrans(
                "После активации вашей новой учетной записи вам нужно будет внести средства на свой счет. Торговля требует капитала для удержания позиций на рынке. Вам нужно будет инвестировать минимальную сумму денег для торговли с использованием приложения [website_title]. Чем больше вы инвестируете, тем больше потенциальной прибыли сможете получить. Однако это также означает повышенный риск потерь. Начинающим трейдерам рекомендуется начать с минимального депозита. Это позволит вам изучить основы торговых рынков перед тем, как инвестировать больше средств.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
    </div>
</div>
<div class="col w-col w-col-4 w-col-stack">
    <div class="step-item">
        <div class="step-header">
            <div class="step-header-line-wrapper">
                <div class="step-header-line-text">{{aiTrans('Шаг третий')}}</div>
                <div class="step-header-line"></div>
            </div>
            <h3 class="step-header-line-title">{{aiTrans('Торговля')}}</h3>
        </div>
        <div>{{aiTrans('Наконец, вам нужно будет настроить параметры торговли в программном обеспечении. Приложение может быть настроено в соответствии с вашей собственной терпимостью к риску, предпочтениями и целями торговли. Это обеспечит вам лучший опыт торговли. Как только вы завершите настройку параметров торговли, вы будете готовы начать сделки с использованием нашего мощного алгоритма и рыночного анализа.')}}</div>
    </div>
</div>
</div>
<div class="button-wrapper steps-action-button">
    <a href="#formTop" class="button white w-button">{{aiTrans('Зарегистрируйтесь сейчас, чтобы начать')}}</a>
</div>
</div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Часто задаваемые вопросы')}}</h2>
        <p class="faq-text">{{aiTrans('Вероятно, у вас все еще есть некоторые вопросы о том, как работает наше торговое приложение. Если вы новичок в торговле, скорее всего, у вас будут вопросы о том, с чего начать. Ниже приведены некоторые из самых часто задаваемых вопросов трейдеров.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Что нового в версии [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Новая версия [website_title] — это обновленная версия популярной платформы для криптовалютной торговли, предназначенная для предоставления трейдерам еще более мощных инструментов и ресурсов для успешной работы на рынке криптовалют.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Какие новые функции предоставляет новая версия [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
<div class="faq-arrow">+</div>
</div>
<div class="faq-accordion-wrap">
    <p class="faq-answer">
        {{ aiTrans(
            "Новая версия [website_title] предлагает ряд новых функций, включая продвинутые инструменты управления рисками, данные о рынке в реальном времени, настраиваемые таблицы и графики, а также анализ новостей и событий.",
            $locale,
            ['website_title' => $website_title],
        ) }}
    </p>
</div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">3</div>
        <h3 class="heading">
            {{ aiTrans(
                "Новая версия [website_title] безопасна для использования?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
            {{ aiTrans(
                "Да, новая версия [website_title] безопасна для использования. Платформа использует передовые меры безопасности для защиты данных и транзакций пользователей, а наша команда специалистов следит за платформой круглосуточно, чтобы гарантировать ее безопасность и надежность.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">4</div>
        <h3 class="heading">
            {{ aiTrans(
                "Могу ли я настроить свой торговый опыт с новой версией [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
            {{ aiTrans(
                "Да, новая версия [website_title] позволяет вам настроить свой торговый опыт, включая настраиваемые таблицы и графики, которые позволяют легко визуализировать данные рынка и тенденции.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">5</div>
        <h3 class="heading">
            {{ aiTrans(
                "Подходит ли новая версия [website_title] для начинающих?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
            {{ aiTrans(
                "Да, новая версия [website_title] подходит для начинающих. Платформа удобна в использовании и легка в навигации, и наша команда специалистов готова предоставить руководство и поддержку трейдерам любого уровня.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
</div>
<div class="button-wrapper">
    <a href="#formTop" class="button w-button">{{aiTrans("ЗАРЕГИСТРИРОВАТЬСЯ СЕЙЧАС")}}!</a>
</div>
</div>
<div class="faq-bg-2"></div>
<div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Особенности",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Особенности" class="high-img">
                    <div class="high-text">{{aiTrans('Тип')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI торговый робот')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Особенности" class="high-img">
                    <div class="high-text">{{aiTrans('Стоимость приложения')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Бесплатно')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Особенности" class="high-img">
                    <div class="high-text">Сборы</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Нет')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Особенности" class="high-img">
                    <div class="high-text">{{aiTrans('Демо-аккаунт')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Да')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Особенности" class="high-img">
                    <div class="high-text">{{aiTrans('Активы')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH и другие')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Особенности" class="high-img">
                    <div class="high-text">{{aiTrans('Защита данных пользователя')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Да')}}</div>


                </div>
            </div>
        </div>
    </div>
</div>
@endsection
