@extends('layouts.app')
@section('title', $website_title .' | Política de Privacidade')
@php( $meta_description = "Descubra como ". $website_title." protege seus dados pessoais. Nossa política de privacidade detalha as medidas que tomamos para garantir a segurança e a transparência das suas informações.")

@section('content')



<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>PRIVACYBELEID</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Introductie', $locale) }}</h3>
<p>
    {{ aiTrans('Deze verklaring beschrijft het privacybeleid dat wordt gevolgd door', $locale) }} {{ $website_title }} ("{{ aiTrans('wij', $locale) }}," "{{ aiTrans('onze', $locale) }}," "{{ aiTrans('of', $locale) }}")
    {{ aiTrans('met betrekking tot onze producten en diensten (de "Diensten") en de', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('website', $locale) }}</a>
    {{ aiTrans('de ("Website")', $locale) }}. {{ aiTrans('Het beschermen van uw privacy en de vertrouwelijkheid van uw informatie is cruciaal voor ons bij het leveren van onze Diensten en het beheren van de Website.', $locale) }}
</p>
<p>
    {{ aiTrans('Onze Diensten en Website kunnen links bevatten naar websites en diensten van derden. Wij zijn niet verantwoordelijk voor het privacybeleid van deze externe entiteiten. Wij raden u aan hun privacybeleiden te bekijken voordat u ze gebruikt.', $locale) }}
</p>
<p>
    {{ aiTrans('Alle informatie die wij verkrijgen in verband met onze Diensten wordt behandeld als vertrouwelijk. Wij gebruiken robuuste technische, beveiligings- en organisatorische maatregelen om Persoonsgegevens (zoals hieronder gedefinieerd) te beschermen tegen ongeautoriseerde verwerking, accidenteel verlies, vernietiging, schade, diefstal of openbaarmaking.', $locale) }}
</p>
<p>
    {{ aiTrans('Wanneer u uw informatie via onze website indient, kan het zijn dat u wordt gevraagd persoonlijke gegevens te verstrekken, zoals uw naam, e-mailadres, telefoonnummer, geboortedatum en andere identificerende gegevens. Deze informatie kan voor andere doeleinden worden gebruikt, zoals het verifiëren van identiteit, het beheren van informatie, het bieden van technische ondersteuning en het voldoen aan contractuele en wettelijke verplichtingen. Wij kunnen belangrijke details met u communiceren via meldingen, en met uw toestemming, informatie verstrekken over producten en diensten via sms, e-mail, enz. U heeft de mogelijkheid om voorkeuren voor meldingen te beheren en u af te melden voor bepaalde communicatie.', $locale) }}
</p>
<h3>{{ aiTrans('2. Website; Bezoekers en Gebruikers', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Algemeen', $locale) }}</h4>
<p>
    {{ aiTrans('Deze sectie beschrijft de specifics van het verzamelen van gegevens van verschillende groepen: websitebezoekers ("Bezoekers"), gebruikers ("Gebruikers") en zakelijke partners (gezamenlijk "Partners"). Persoonsgegevens omvatten IP-adres, naam, contactgegevens en informatie over de relatie met ons, zoals gedefinieerd door de toepasselijke gegevensbeschermingsregelgeving.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Verzameling en Gebruik', $locale) }}</h4>
<p>
    {{ aiTrans('Door de Website te bezoeken, stemt u in met de verzameling en het gebruik van uw Persoonsgegevens. Het niet akkoord gaan met deze voorwaarden zou u moeten verhinderen de Website te bezoeken. We kunnen informatie verzamelen door middel van paginabezoeken, IP-adressen en cookies. Daarnaast verwerken we gegevens die vrijwillig via formulieren en registraties worden verstrekt.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Doel van de Verwerking van Persoonsgegevens', $locale) }}</h4>
<p>
    {{ aiTrans('We verwerken Persoonsgegevens om onze Website en Diensten te verbeteren, te begrijpen en te personaliseren. Dit omvat het verbeteren van de nauwkeurigheid, communicatie over Diensten, ondersteuning, contractuele verplichtingen en samenwerking met partners. Toestemming of een wettelijke basis is essentieel voor elke verwerking.', $locale) }}
</p>
<p>{{ aiTrans('Het volgende beschrijft de doeleinden en de juridische basis voor de verwerking van Persoonsgegevens:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registratie als accounthouder', $locale) }}</td>
            <td>{{ aiTrans('Uw toestemming; Uitvoering van Diensten of contractuele verplichtingen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Verstrekking en gebruik van Diensten', $locale) }}</td>
            <td>{{ aiTrans('Uitvoering van Diensten of contractuele verplichtingen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Operationele updates', $locale) }}</td>
            <td>{{ aiTrans('Uitvoering van Diensten of contractuele verplichtingen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Beantwoorden van vragen en bieden van ondersteuning', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen of uitvoering van Diensten', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Diensten, advertenties en op maat gemaakte marketing', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen of uw toestemming', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Verbetering en aanbod van nieuwe Diensten', $locale) }}</td>
            <td>{{ aiTrans('Toestemming en legitieme belangen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Verzending van promotionele en marketingmaterialen', $locale) }}</td>
            <td>{{ aiTrans('Uw toestemming', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse van de effectiviteit van marketingcampagnes', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen of toestemming', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Uitvoering van verschillende ondersteuningsactiviteiten', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen of uitvoering van Diensten', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse, inclusief statistische analyse', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Bescherming van belangen, rechten en bezittingen', $locale) }}</td>
            <td>{{ aiTrans('Legitieme belangen of wettelijke verplichtingen', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Delen van Persoonsgegevens', $locale) }}</h4>
<p>
    {{ aiTrans('We kunnen informatie delen met dienstverleners, Partners en contractanten. Voor Bezoekers en Gebruikers in de Europese Gegevensregio, wordt de gegevensverwerking uitgevoerd in overeenstemming met de GDPR en de toepasselijke Gegevensbeschermingswetten.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partners', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Algemeen', $locale) }}</h4>
<p>
    {{ aiTrans('Om Diensten te leveren en samen te werken met Partners, verzamelen en verwerken we specifieke soorten gegevens. Partners zijn verantwoordelijk voor hun gegevens en we kunnen er veilig toegang toe krijgen.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Verwerking van Persoonsgegevens', $locale) }}</h4>
<p>
    {{ aiTrans('We vertrouwen op de toestemming van Partners of legitieme belangen om Persoonsgegevens te verwerken. Gegevensaggregaten kunnen worden gecreëerd voor de ontwikkeling en verbetering van de kwaliteit.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Verantwoordelijke/Verwerker', $locale) }}</h4>
<p>{{ aiTrans('We kunnen optreden als Verantwoordelijke of Verwerker, afhankelijk van het type gegevens:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Bezoekers/Gebruikers Gegevens: Verantwoordelijke', $locale) }}</li>
    <li>{{ aiTrans('Partnergegevens: Verwerker', $locale) }}</li>
    <li>{{ aiTrans('Alle gegevens worden veilig gehost, volgens de hoogste beveiligingsnormen. We implementeren fysieke, technische en organisatorische waarborgen.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Bescherming van Derde Gegevens', $locale) }}</h4>
<p>{{ aiTrans('Als de Diensten de verwerking van Persoonsgegevens op een derde platform omvatten:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('We treden op als Verwerker', $locale) }}</li>
    <li>{{ aiTrans('We volgen de instructies van de derde partij op', $locale) }}</li>
    <li>{{ aiTrans('We implementeren beveiligingsmaatregelen', $locale) }}</li>
    <li>{{ aiTrans('We informeren over datalekken', $locale) }}</li>
    <li>{{ aiTrans('We zullen niet uitbesteden zonder toestemming', $locale) }}</li>
    <li>{{ aiTrans('We verwerken geen gegevens buiten de Europese Economische Ruimte zonder toestemming', $locale) }}</li>
    <li>{{ aiTrans('Voor elektronische marketingcommunicatie garanderen we toestemming en opt-out opties.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Beveiliging', $locale) }}</h3>




<p>
    {{ aiTrans('We gebruiken administratieve, organisatorische en technische waarborgen om Persoonsgegevens te beschermen tegen ongeautoriseerde toegang, openbaarmaking, wijziging, verlies, misbruik of schade. Wanneer we gegevens met derden delen, zorgen we ervoor dat zij dezelfde gegevensbeschermingsnormen handhaven, en worden contractuele verplichtingen vastgesteld voor exclusieve en veilige verwerking, in overeenstemming met dit beleid.', $locale) }}
</p>
<p>
    {{ aiTrans('Als er reden is om aan te nemen dat de interactie met ons is aangetast, moeten Bezoekers, Gebruikers of Partners ons onmiddellijk op de hoogte stellen. Het is belangrijk op te merken dat, ondanks onze beveiligingsmaatregelen, we geen volledige immuniteit kunnen garanderen tegen aanvallen van derden. Gebruikers erkennen de inherente risico’s en mogelijke schendingen.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Raadpleeg ons', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Cookiebeleid', $locale) }}</a> {{ aiTrans('voor gedetailleerde informatie over de soorten cookies en trackingtechnologieën die op de Website worden gebruikt, de redenen voor gebruik en hoe ze te accepteren of te weigeren.', $locale) }}
</p>
<h3>{{ aiTrans('6. Links naar Andere Websites', $locale) }}</h3>
<p>
    {{ aiTrans('Tijdens het navigeren op de Website kunnen Gebruikers links naar externe websites vinden die buiten onze controle vallen. Wij zijn niet verantwoordelijk voor de inhoud of privacybeleid van deze websites. Gebruikers wordt aangeraden de privacybeleidsregels van dergelijke websites en derde-diensten te raadplegen voordat ze Persoonsgegevens verstrekken.', $locale) }}
</p>
<h3>{{ aiTrans('7. Bewaring en Verwijdering', $locale) }}</h3>
<p>
    {{ aiTrans('Gegevens, inclusief Persoonsgegevens, worden niet langer bewaard dan noodzakelijk is. Bezoekers en/of Gebruikers met actieve accounts zijn verantwoordelijk voor het tijdig verwijderen van gegevens. Na het beëindigen van een account of samenwerking, worden de Persoonsgegevens die via de Website en/of Diensten zijn verzameld verwijderd in overeenstemming met de toepasselijke wetten en ons interne beleid.', $locale) }}
</p>
<p>
    {{ aiTrans('Het intrekken van toestemming voor de verwerking van Persoonsgegevens kan de toegang tot sommige of alle aangevraagde Diensten beperken, zonder dat er claims of tegenhouden mogelijk zijn.', $locale) }}
</p>
<h3>{{ aiTrans('8. Uw Rechten', $locale) }}</h3>
<p>{{ aiTrans('Gebruikers hebben specifieke rechten met betrekking tot hun Persoonsgegevens:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Recht op Toegang', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Bevestigen of Persoonsgegevens worden verwerkt', $locale) }}</li>
    <li>{{ aiTrans('Toegang tot Persoonsgegevens en gerelateerde informatie', $locale) }}</li>
    <li>{{ aiTrans('Informatie over de doeleinden van verwerking, categorieën, ontvangers, opslagduur, rechten en de aanwezigheid van profielen', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Recht op Correctie', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Corrigeren van onnauwkeurige Persoonsgegevens', $locale) }}</li>
    <li>{{ aiTrans('Voltooien van onvolledige Persoonsgegevens', $locale) }}</li>
</ul>


</ul>
<h4>{{ aiTrans('8.3. Recht op Verwijdering', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Verzoeken om Persoonsgegevens te verwijderen onder specifieke omstandigheden', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Recht op Beperkingen van Verwerking', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Beperkingen op verwerking verkrijgen onder specifieke omstandigheden', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Recht op Gegevensoverdraagbaarheid', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Ontvangen van Persoonsgegevens in een gestructureerd, machine-leesbaar formaat', $locale) }}</li>
    <li>{{ aiTrans('Persoonsgegevens overdragen aan een andere verwerkingsverantwoordelijke', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Recht van Bezwaar', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Bezwaar maken tegen verwerking op basis van legitieme belangen of direct marketing', $locale) }}</li>
    <li>{{ aiTrans('De verwerking stoppen, tenzij er overtuigende en/of juridische redenen zijn die van toepassing zijn', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Recht om Toestemming in te trekken', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Toestemming voor de verwerking van Persoonsgegevens op elk moment intrekken', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Reclame- en Marketingmaterialen', $locale) }}</h3>
<p>
    {{ aiTrans('Toestemming wordt verkregen voor het gebruik van Persoonsgegevens en contactgegevens om reclame- en marketingmaterialen te verstrekken. Het intrekken van toestemming is mogelijk door een schriftelijke kennisgeving te sturen naar het opgegeven e-mailadres.', $locale) }}
</p>
<h3>{{ aiTrans('10. Acceptatie van dit Beleid', $locale) }}</h3>
<p>
    {{ aiTrans('Door de Website en/of de Diensten te gebruiken, wordt aangenomen dat Bezoekers, Gebruikers en/of Partners deze Beleidsregels hebben gelezen en ermee akkoord zijn gegaan. Eventuele bezwaren impliceren dat de gebruiker zich van het gebruik van het platform onthoudt. Wij behouden ons het recht voor om het Beleid te wijzigen, en Gebruikers worden aangemoedigd om periodiek updates te controleren. Door de wijzigingen continu te gebruiken, wordt akkoord gegeven.', $locale) }}
</p>
<h3>{{ aiTrans('11. Wettelijke Verplichting om Persoonsgegevens te Openbaren', $locale) }}</h3>
<p>
    {{ aiTrans('Persoonsgegevens kunnen zonder voorafgaande toestemming worden gedeeld indien er reden is om te geloven dat het nodig is om de identiteit vast te stellen, contact op te nemen of juridische procedures te starten tegen individuen die verdacht worden van schending van rechten of eigendommen. De openbaarmaking zal plaatsvinden wanneer wettelijk vereist.', $locale) }}
</p>
<h3>{{ aiTrans('12. Gegevensbeschermingsfunctionaris', $locale) }}</h3>
            <p>
                {{ aiTrans('Voor privacy- en gegevensbeschermingskwesties kan een aangewezen "Gegevensbeschermingsfunctionaris" worden bereikt via het e-mailadres', $locale) }} <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Toepasselijke wetten:', $locale) }}</b> {{ aiTrans('Wetten van de EU of het lidstaat over persoonsgegevens onderhevig aan de gegevensbeschermingswetten van de EU en andere toepasselijke wetten voor persoonsgegevens onderhevig aan andere gegevensbeschermingswetten.', $locale) }}
    </li>
    <li>
        <b>{{ aiTrans('Verantwoordelijke:', $locale) }}</b> {{ aiTrans('Entiteit die de doeleinden en middelen voor de verwerking van persoonsgegevens bepaalt.', $locale) }}
    </li>
    <li>
        <b>{{ aiTrans('Gegevensbeschermingswetten:', $locale) }}</b> {{ aiTrans('Gegevensbeschermingswetten van de EU en de privacywetgeving van elk ander land.', $locale) }}
    </li>
    <li>
        <b>{{ aiTrans('EU Gegevensbeschermingswetten:', $locale) }}</b> {{ aiTrans('Richtlijn 95/46/EG van de EU, GDPR en gerelateerde wetgeving.', $locale) }}
    </li>
    <li>
        <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('Algemene Verordening Gegevensbescherming van de EU 2016/679.', $locale) }}
    </li>
</ol>
</li>
<li>
    <b>{{ aiTrans('Verzameling en verwerking van persoonsgegevens', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Wij stemmen ermee in om alle toepasselijke gegevensbeschermingswetten na te leven bij het verwerken van persoonsgegevens.', $locale) }}
            <ol class="nested-list">
                <li>
                    {{ aiTrans('We verklaren en garanderen dat we de nodige toestemming van de gegevenssubjecten hebben om legaal persoonsgegevens te verzamelen, verwerken en delen via de Diensten in overeenstemming met de toepasselijke wetten.', $locale) }}
                </li>
                <li>
                    {{ aiTrans('We zullen een mechanisme onderhouden om toestemming te verkrijgen en in te trekken, in overeenstemming met de toepasselijke wetten, en een publiek beschikbare privacyverklaring.', $locale) }}
                </li>
                <li>
                    {{ aiTrans('We erkennen dat we geen diensten aanbieden aan kinderen onder de achttien (18) jaar.', $locale) }}
                </li>
            </ol>
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Beveiliging', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('We zullen passende technische en organisatorische maatregelen implementeren voor gegevensbeveiliging in overeenstemming met Artikel 32(1) van de GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Subverwerking', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('U staat ons toe om subverwerkers aan te wijzen en ervoor te zorgen dat schriftelijke contracten met subverwerkers hetzelfde niveau van bescherming voor persoonsgegevens bieden zoals beschreven in deze bijlage en voldoen aan de vereisten van de GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Rechten van de betrokkenen', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('We zullen helpen bij het beantwoorden van verzoeken van betrokkenen volgens de gegevensbeschermingswetten, rekening houdend met de aard van de verwerking.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Schending van persoonsgegevens', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('We zullen de betrokkenen onmiddellijk informeren zodra we kennis nemen van een schending van persoonsgegevens, en helpen bij het onderzoeken, mitigeren en herstellen.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Algemene voorwaarden', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Geschillen of claims die voortvloeien uit deze voorwaarden zijn onderworpen aan de hier vastgestelde rechtsmacht. Als enige bepaling ongeldig is, blijven de overige van kracht.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Wijzigingen', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Wijzigingen in deze voorwaarden kunnen van tijd tot tijd worden aangebracht naar eigen goeddunken', $locale) }}
        </li>
    </ol>
</li>
</ol>
<p>
    {{ aiTrans('Door akkoord te gaan met deze voorwaarden erkent u dat u ze hebt gelezen, begrepen en ermee instemt gebonden te zijn aan alle bovengenoemde voorwaarden. Uw voortdurende gebruik van de Website en de Diensten betekent dat u akkoord gaat met deze voorwaarden. Als u vragen of zorgen heeft, neem dan contact met ons op via') }} <span>info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>



    </div>
</div>
@endsection
