@extends('layouts.app')
@section('title', $website_title .' | 利用規約')
@php( $meta_description = "利用規約をお読みください。私たちの規約は、あなたの権利、責任、そして私たちのサービスを安全かつ効果的に使用する方法について説明しています。")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>利用規約</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('私たちの')}} <a href="{{ route('home', $country) }}">ウェブサイト</a> {{aiTrans('（「ウェブサイト」）にアクセスしていただき、こちらの利用規約（「利用規約」）および私たちの')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('プライバシーポリシー')}}</a> {{aiTrans('（「プライバシーポリシー」）へのリンクを見つけたことに感謝します。このウェブサイトは')}} {{ $website_title }}{{aiTrans('によって運営および管理されており、当社の親会社、子会社、または関連会社をすべて含み、総称して')}} {{ $website_title }}{{aiTrans('と呼ばれます。ウェブサイトは私たちの所有物であり、私たち（「私たち」、「私たちの」または「私たち」と呼ばれます）により管理されています。いつでもメールで私たちに連絡することができます：')}}
                    <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('ウェブサイトにアクセスしたり、私たちの製品および/またはサービス（「サービス提供者のサービス」と、サービスサブスクリプションサービスと合わせて「サービス」）を利用することにより、あなたはこれらの利用規約（「規約」）および私たちのプライバシーポリシーに従うことに同意したことになります。これらの規約には、運用ルール、ポリシー、情報およびその他の補足的な条件が含まれています。私たちは予告なしに、または私たちの裁量で、規約を変更する権利を保留します。規約の更新については定期的にこのページを確認する責任はあなたにあります。更新された規約は公開後に発効します。ウェブサイトの継続的な利用は規約の受け入れを意味します。', $locale) }}
                </p>
                <p>
                    {{ aiTrans('この利用規約の全文を慎重にご確認ください。もしその内容に同意できない場合、サービスまたはウェブサイトを使用することはできません。私たちは、サービスおよび/またはウェブサイトへのアクセスを私たちの裁量で拒否する権利を保留します。', $locale) }}
                </p>
                <h3>{{ aiTrans('投資アドバイスなし', $locale) }}</h3>
<p>
    {{ aiTrans('明示的に異なる旨が記載されていない限り、このウェブサイトは個別の投資や金融アドバイスを提供することを目的としていません。提供される情報は、あなたの具体的な投資目標、財務状況、または投資ニーズを考慮したものではありません。', $locale) }}
</p>
<p>
    {{ aiTrans('このウェブサイトの情報があなたの投資目標、財務状況、投資ニーズに適しているかどうかを評価する必要があります。この評価は、情報に基づいて投資決定を行う前に行うべきです。自分自身でこの評価を行うか、独立した金融アドバイザーの助けを求めることができます。', $locale) }}
</p>
<p>
    {{ aiTrans('明示的に異なる旨が記載されていない限り、このウェブサイトに含まれる情報は、IGグループのいかなるメンバーによって提供される金融商品やサービスへの投資勧告を構成するものではありません。', $locale) }}
</p>
<h3>{{ aiTrans('製品とサービス', $locale) }}</h3>
<p>
    {{ aiTrans('このウェブサイトで言及されているすべての製品やサービスが必ずしも私たちによって提供されているわけではありません。第三者の製品、サービス、ウェブサイト、またはネットワークの識別や使用は、それらの製品、サービス、ウェブサイト、またはネットワークの推奨を構成するものではありません。このウェブサイトでは、ハイパーリンクまたはその他のリンクを通じて、私たちではない第三者が提供するウェブサイトやネットワークにアクセスできる場合があります。', $locale) }}
</p>
<p>
    {{ aiTrans('私たちは、私たちの管理下にないウェブサイトやネットワークのコンテンツに関して、いかなる責任も負いません。これらのウェブサイトやネットワークへのアクセスが、あなたの個人情報をその所有者に提供する義務を生じる可能性があることを認識しています。このウェブサイトの内容は、いずれも、または私たちからの投資アドバイスや金融アドバイスとして解釈されるべきではないことをご理解ください。', $locale) }}
</p>
<h3>{{ aiTrans('範囲と変更', $locale) }}</h3>
<p>
    {{ aiTrans('この文書に記載されている条件に従い、ウェブサイトの使用について合意するものとします。これらの規約は、ウェブサイトに関連する以前の合意、表明、保証、および理解をすべて置き換える完全な合意を構成します。', $locale) }}
</p>
<p>
    {{ aiTrans('これらの規約は定期的に変更されることがあります。規約を変更した場合、変更に伴う選択肢について通知し、変更を通知する告知を公開します。ウェブサイトおよび/または私たちのサービスの継続的な使用は、その時点での更新された規約に従うことに完全に同意したことを意味します。定期的にこのページを確認して、更新や変更について確認することはあなたの責任です。', $locale) }}
</p>
<h3>{{ aiTrans('要件', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイトおよび私たちのサービスは、適用される法律に基づいて法的に拘束力のある契約を締結する資格のある個人にのみ提供されます。これらは18歳未満の個人には利用できません。もしあなたが18歳未満であれば、ウェブサイトおよび/またはサービスを使用およびアクセスすることはできません。', $locale) }}
</p>
<h3>{{ aiTrans('サービスの説明', $locale) }}</h3>
<p>
    <i>{{ aiTrans('サブスクリプションサービス：', $locale) }}</i> {{ aiTrans('ウェブサイトに登録して私たちの承認を得ると、サブスクリプションサービスを料金で、または無料で利用することができます。これらのサービスは、私たちおよび第三者のパートナーによるオンラインマーケティングに関連するメール、テキスト、その他のコンテンツ（「サブスクリプションコンテンツ」）を提供します。これは投資アドバイスではありません。サブスクリプションコンテンツの正確性、完全性、または適切性について、私たちは責任を負いません。', $locale) }}
</p>
<p>
    <i>{{ aiTrans('第三者およびパートナーサービス：', $locale) }}</i> {{ aiTrans('登録フォームを記入すると、ウェブサイトから特定の製品やサービスを取得することができます。ウェブサイトに記載されている製品やサービスの説明は第三者の提供者から提供されることがあります。私たちはその正確性や完全性を保証しません。私たちは、あなたが製品やサービスを取得できなかった場合、またはウェブサイトや提携パートナーとの間で起こる紛争について責任を負いません。', $locale) }}
</p>
<p>
    <i>{{ aiTrans('一般：', $locale) }}</i> {{ aiTrans('サービスを利用するには、正確なサービス登録データを提供する必要があります。私たちは不完全、不正、または受け入れられないデータを拒否する権利を保留します。明示的に別の方法で記載されていない限り、ウェブサイトの機能を強化する今後のオファーはこれらの規約の対象となります。私たちは、あなたがサービスを利用できない場合、またはサービスに資格がない場合、さらにその変更、停止、または廃止について責任を負いません。', $locale) }}
</p>
<h3>{{ aiTrans('所有権', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイト、コンテンツ、サービス（組織、グラフィック、デザイン、コンパイル、ソフトウェアなどを含む）は、著作権、商標、およびその他の適用される所有権によって保護されています。ウェブサイト、コンテンツ、サービスのいかなる部分の複製、再配布、販売は厳しく禁止されています。自動化された手段またはスクレイピングを使用して、書面による許可なしにコンテンツを取得することは禁じられています。ウェブサイト上のコンテンツ、文書、ソフトウェア、サービス、または資料に関する所有権は取得しません。私たちの名前、ロゴ、グラフィック、アイコン、サービス名は商標です。商標の無断使用は厳しく禁じられています。', $locale) }}
</p>
<h3>{{ aiTrans('機密情報', $locale) }}</h3>
<p>
    {{ aiTrans('機密情報とは、そのように識別された所有情報を指し、公開された情報、既存の知識、独立して開発された情報、または第三者から提供された情報は含まれません。機密情報の保護義務は、終了後1年で満了します。', $locale) }}
</p>
<h3>{{ aiTrans('ウェブサイトへのハイパーリンク、コブランド、フレーミングおよび/またはウェブサイトの参照の禁止', $locale) }}</h3>
<p>
    {{ aiTrans('私たちの明示的な許可なしに、ウェブサイトまたはその一部へのハイパーリンクを他のウェブサイトに設置することは禁止されています。ウェブサイトをフレーミングしたり、URLを参照することは書面による許可なしに厳しく禁じられています。このようなコンテンツや活動を削除する協力は義務であり、あなたはそれに伴う損害について責任を負います。', $locale) }}
</p>
<h3>{{ aiTrans('編集、削除および変更', $locale) }}</h3>

<p>
    {{ aiTrans('私たちは、ウェブサイト上の文書、情報、またはコンテンツを事前通知なしに編集および/または削除する権利を保留します。', $locale) }}
</p>
<h3>{{ aiTrans('責任の免除', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイト、サービス、コンテンツ、および第三者製品は、「現状のまま」および「利用可能な状態で」提供され、適用される法律が許す最大限度で明示的および暗黙的なすべての保証を除外します。ウェブサイト、サービス、コンテンツ、および/または第三者製品があなたの要求に応じるか、途切れなく、タイムリーで、安全で、エラーがないことを保証するものではありません。ウェブサイト、サービス、コンテンツ、および/または第三者製品の使用不能に関連するいかなるクレームについても、私たちは責任を負いません。ウェブサイトにはバグ、エラー、または制限が含まれている可能性があり、インターネット接続の可用性について私たちは責任を負いません。', $locale) }}
</p>
<h3>{{ aiTrans('責任の制限', $locale) }}</h3>
<p>
    {{ aiTrans('私たちは、直接的、間接的、偶発的、特別または模範的な損害、利益の損失、信用、使用、データまたはその他の無形の損失に対して責任を負いません。この制限は、契約違反、保証、過失、客観的責任、虚偽の表示、またはその他の不法行為に関連するすべての訴因に適用されます。私たちは、あなたがウェブサイト、サービス、コンテンツ、および/または第三者製品を使用できなかったことに起因する責任から免責され、また、第三者の製品やサービスとの紛争についても免責されます。適用される法律がこの制限を許可しない場合、私たちの最大責任額は500ドル（$500.00）となります。', $locale) }}
</p>
<h3>{{ aiTrans('賠償', $locale) }}</h3>
<p>
    {{ aiTrans('あなたは、ウェブサイト、サービス、コンテンツの使用、これらの規約の違反、または他の個人や法人の権利の違反に起因する、私たち、私たちのパートナー、子会社、関連会社、およびそのメンバー、取締役、従業員、代理人、パートナーに対するすべての請求、費用、損害、訴訟、コスト、要求、および/または裁判から免責し、私たちに補償することに同意します。', $locale) }}
</p>
<h3>{{ aiTrans('第三者ウェブサイト', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイトは、第三者提供者が所有する他のウェブサイトおよび/またはインターネットリソースへのリンクを提供することがあります。私たちは、これらの第三者ウェブサイトおよび/またはリソースの可用性やその内容について責任を負わず、これらのウェブサイト、プライバシーポリシー、コンテンツ、広告、サービス、製品または資料について推薦したり責任を負うものではありません。', $locale) }}
</p>
<h3>{{ aiTrans('プライバシーポリシー/訪問者の情報', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイトの使用およびすべてのコメント、フィードバック、情報、登録データおよび/または送信された資料は、私たちのプライバシーポリシーの対象となります。私たちは、ウェブサイトの使用に関する情報および個人識別可能な情報を、私たちのプライバシーポリシーおよび適用されるデータ保護法に従って使用する権利を保留します。', $locale) }}
</p>
<h3>{{ aiTrans('法的警告', $locale) }}</h3>
<p>
    {{ aiTrans('ウェブサイトの操作を損なったり、破壊したり、改ざんしたり、汚損したり、干渉したりする試みは、刑事および民事法の違反です。違反者に対して、適用される法律および衡平法の最大限度で法的措置を取るつもりです。', $locale) }}
</p>
<h3>{{ aiTrans('適用法および裁判所', $locale) }}</h3>
<p>
    {{ aiTrans('これらの規約は、イギリスの法律に従って解釈されます。各当事者は、これらの規約に関連するクレームまたは紛争を誠実に交渉し解決しようと努めます。交渉が合意に至らなかった場合、その紛争はロンドンで開催される秘密の仲裁手続きに専用で提出されます。仲裁の判決は最終的かつ拘束力があります。いかなる当事者も、地元の裁判所またはその他の管轄裁判所にクレームを提起することはありません。', $locale) }}
</p>
<h3>{{ aiTrans('データ保護アタッチメント', $locale) }}</h3>
<p>
    {{ aiTrans('このデータ保護アタッチメントは、私たちの利用規約の一部です。ここで使用される用語は、このアタッチメントで指定された意味を持ちます。以下で修正されていない限り、規約は完全に有効であり続けます。', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('定義', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('適用法:', $locale) }}</b> {{ aiTrans('EUおよびEUデータ保護法およびその他の適用されるデータ保護法に従う個人データに関するEUまたは加盟国の法令。', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('データ管理者:', $locale) }}</b> {{ aiTrans('個人データの処理の目的および手段を決定する団体。', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('データ保護法:', $locale) }}</b> {{ aiTrans('EUのデータ保護法およびその他の国のデータ保護法またはプライバシー法。', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('EUのデータ保護法:', $locale) }}</b> {{ aiTrans('EU指令95/46/EC、GDPR、および関連法。', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('EU一般データ保護規則2016/679。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('個人データの収集と処理', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('私たちは、個人データ処理に関して適用されるすべてのデータ保護法を遵守することに同意します。', $locale) }}
                <ol class="nested-list">
                    <li>
                        {{ aiTrans('私たちは、データ所有者から収集、処理、共有のために必要な許可と同意を合法的に取得していることを宣言し、保証します。', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('私たちは、適用法に従い、同意を取得および撤回するためのメカニズムと公開されたプライバシーポリシーを保持します。', $locale) }}
                    </li>
                    <li>
                        {{ aiTrans('私たちは、18歳未満の子供にサービスを提供しないことを認識しています。', $locale) }}
                    </li>
                </ol>
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('セキュリティ', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('GDPRの第32条（1）に従い、データのセキュリティのために適切な技術的および組織的措置を実施します。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('サブプロセッシング', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('私たちは、サブプロセッサを指名することを許可され、サブプロセッサとの契約がこのアタッチメントで記載された個人データの保護を同等に確保し、GDPRの要件を満たすことを保証します。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('データ所有者の権利', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('私たちは、データ保護法に従って、処理の性質に応じて、データ所有者の権利要求に対応する手助けをします。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('個人データの侵害', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('私たちは、個人データの侵害を認識した場合、影響を受けたデータ所有者に直ちに通知し、調査、軽減、および修復の支援を行います。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('一般的な条件', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('これらの規約に起因する紛争またはクレームは、ここに記載された管轄権に従います。無効な条項があった場合でも、残りの条項は有効です。', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('変更', $locale) }}</b>
        <ol class="nested-list">
            <li>
                {{ aiTrans('これらの規約は、私たちの単独の裁量で時折変更されることがあります。', $locale) }}
            </li>
        </ol>
    </li>
</ol>
<p>
    {{ aiTrans('これらの規約に同意することにより、あなたは上記のすべての条件を読み、理解し、同意したことを認めます。ウェブサイトおよびサービスの継続的な使用は、これらの条件に同意することを意味します。質問や懸念がある場合は、以下のメールでご連絡ください：') }} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>

            </div>
        </div>
    </div>
@endsection
