@extends('layouts.app')
@section('title', $website_title .' | Tietosuojakäytäntö')
@php( $meta_description = "Löydä, miten ". $website_title." suojaa henkilökohtaisia tietojasi. Tietosuojakäytäntömme kuvaa toimenpiteet, joita toteutamme varmistaaksemme tietojesi turvallisuuden ja läpinäkyvyyden.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>Tietosuojakäytäntö</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Johdanto', $locale) }}</h3>
<p>
    {{ aiTrans('Tässä ilmoituksessa kuvataan', $locale) }} {{ $website_title }} ("{{ aiTrans('me', $locale) }}," "{{ aiTrans('meidän', $locale) }}," "{{ aiTrans('tai', $locale) }}")
    {{ aiTrans('käyttämät tietosuojakäytännöt tuotteidemme ja palvelujemme ("Palvelut") sekä', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('verkkosivusto', $locale) }}</a>
    {{ aiTrans('("Sivusto")". Tietosi suojaaminen ja niiden luottamuksellisuus on meille tärkeää tarjotessamme Palveluja ja toimiessamme Sivustolla.', $locale) }}
</p>
<p>
    {{ aiTrans('Palvelumme ja Sivustomme voivat sisältää linkkejä kolmansien osapuolien verkkosivustoille ja palveluihin. Emme ole vastuussa näiden kolmansien osapuolten tietosuojakäytännöistä. Suosittelemme, että tutustut niiden tietosuojakäytäntöihin ennen käyttöä.', $locale) }}
</p>
<p>
    {{ aiTrans('Kaikki meille saapuvat tiedot Palveluihin liittyen käsitellään luottamuksellisina. Käytämme vahvoja teknisiä, turvallisuus- ja organisatorisia toimenpiteitä suojataksemme Henkilötiedot (määritelty alla) luvattomalta käsittelyltä, satunnaiselta menetykseltä, tuhoutumiselta, vahingolta, varastamiselta tai paljastamiselta.', $locale) }}
</p>
<p>
    {{ aiTrans('Kun lähetät tietosi verkkosivustomme kautta, sinulta saatetaan pyytää henkilökohtaisia tietoja, kuten nimesi, sähköpostiosoitteesi, puhelinnumerosi, syntymäaikasi ja muita tunnistamistietoja. Näitä tietoja voidaan käyttää muun muassa henkilöllisyytesi tarkistamiseen, tietojen hallintaan, teknisen tuen tarjoamiseen sekä sopimusvelvoitteiden ja lakivelvoitteiden täyttämiseen. Voimme lähettää tärkeitä tietoja ilmoitusten kautta ja suostumuksellasi lähettää tietoja tuotteista ja palveluista SMS:llä, sähköpostilla jne. Voit hallita ilmoitusasetuksia ja peruuttaa tietyt viestit.', $locale) }}
</p>
<h3>{{ aiTrans('2. Sivusto; Vierailijat ja Käyttäjät', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Yleistä', $locale) }}</h4>
<p>
    {{ aiTrans('Tässä osassa kuvataan tiedonkeruun erityispiirteet eri ryhmistä: verkkosivuston vierailijat ("Vierailijat"), käyttäjät ("Käyttäjät") ja liikekumppanit (yhteisesti "Kumppanit"). Henkilötiedot sisältävät IP-osoitteen, nimen, yhteystiedot ja tiedot suhteistamme, kuten on määritelty sovellettavissa tietosuojalakien mukaan.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Tietojen kerääminen ja käyttö', $locale) }}</h4>
<p>
    {{ aiTrans('Vieraillessasi Sivustolla hyväksyt Henkilötietojesi keräämisen ja käytön. Jos et suostu näihin ehtoihin, et voi vierailla Sivustolla. Voimme kerätä tietoja sivukatselutoiminnasta, IP-osoitteista ja evästeistä. Lisäksi käsittelemme tietoja, jotka annat vapaaehtoisesti lomakkeissa ja rekisteröinnissä.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Henkilötietojen käsittelyn tarkoitus', $locale) }}</h4>
<p>
    {{ aiTrans('Käsittelemme Henkilötietoja parantaaksemme, ymmärtääksemme ja räätälöidäksemme Sivustoamme ja Palvelujamme. Tämä sisältää tarkkuuden parantamisen, viestinnän Palveluista, tuen tarjoamisen, sopimusvelvoitteet ja yhteistyön kumppaneiden kanssa. Suostumus tai laillinen perusta on välttämätöntä kaikelle käsittelylle.', $locale) }}
</p>
<p>{{ aiTrans('Seuraavassa kuvataan Henkilötietojen käsittelyn tarkoitukset ja laillinen perusta:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Rekisteröinti tilin haltijana', $locale) }}</td>
            <td>{{ aiTrans('Suostumuksesi; Palvelujen tai sopimusvelvoitteiden täyttäminen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Palvelujen tarjoaminen ja käyttö', $locale) }}</td>
            <td>{{ aiTrans('Palvelujen tai sopimusvelvoitteiden täyttäminen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Toimintapäivitykset', $locale) }}</td>
            <td>{{ aiTrans('Palvelujen tai sopimusvelvoitteiden täyttäminen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Kyselyihin vastaaminen ja tuen tarjoaminen', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut tai Palvelujen täyttäminen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Palvelut, mainonta ja räätälöity markkinointi', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut tai suostumuksesi', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Parannukset ja uusien Palvelujen tarjoaminen', $locale) }}</td>
            <td>{{ aiTrans('Suostumus ja lailliset edut', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Mainos- ja markkinointimateriaalien lähettäminen', $locale) }}</td>
            <td>{{ aiTrans('Suostumuksesi', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Markkinointikampanjoiden tehokkuuden analysointi', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut tai suostumus', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Eri tukitoimintojen suorittaminen', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut tai Palvelujen täyttäminen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyysit, mukaan lukien tilastollinen analyysi', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Kiinteistön, oikeuksien ja omaisuuden suojaaminen', $locale) }}</td>
            <td>{{ aiTrans('Lailliset edut tai lakisääteiset velvoitteet', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Henkilötietojen jakaminen', $locale) }}</h4>
<p>
    {{ aiTrans('Voimme jakaa tietoja palveluntarjoajien, Kumppaneiden ja alihankkijoiden kanssa. Vierailijoille ja Käyttäjille Euroopan talousalueella tietojen käsittely on GDPR:n ja sovellettavien tietosuojalakien mukaista.', $locale) }}
</p>
<h3>{{ aiTrans('3. Kumppanit', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Yleistä', $locale) }}</h4>
<p>
    {{ aiTrans('Tarjotaksemme Palveluja ja tehdäksemme yhteistyötä Kumppaneiden kanssa keräämme ja käsittelemme tiettyjä tietotyyppejä. Kumppanit ovat vastuussa omista tiedoistaan, ja me voimme käyttää niitä turvallisin keinoin.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Henkilötietojen käsittely', $locale) }}</h4>
<p>
    {{ aiTrans('Luotamme Kumppaneiden suostumukseen tai laillisiin etuihin Henkilötietojen käsittelyssä. Tiedot voivat olla yhdistettyjä kehityksen ja laadun parantamiseksi.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Rekisterinpitäjä/Käsittelijä', $locale) }}</h4>
<p>{{ aiTrans('Voimme toimia rekisterinpitäjänä tai käsittelijänä riippuen tiedon tyypistä:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Vierailijat/Käyttäjätiedot: Rekisterinpitäjä', $locale) }}</li>
    <li>{{ aiTrans('Kumppanitiedot: Käsittelijä', $locale) }}</li>
    <li>{{ aiTrans('Kaikki tiedot on isännöity turvallisesti korkeimpien turvallisuusstandardien mukaan. Olemme toteuttaneet fyysisiä, teknisiä ja organisatorisia turvatoimia.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Kolmansien osapuolten tietosuoja', $locale) }}</h4>
<p>{{ aiTrans('Jos Palveluissa käsitellään Henkilötietoja kolmannen osapuolen alustalla:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Toimimme Käsittelijänä', $locale) }}</li>
    <li>{{ aiTrans('Seuraamme kolmannen osapuolen ohjeita', $locale) }}</li>
    <li>{{ aiTrans('Toteutamme turvatoimia', $locale) }}</li>
    <li>{{ aiTrans('Ilmoitamme tietomurroista', $locale) }}</li>
    <li>{{ aiTrans('Emme alihankki tiedon käsittelyä ilman suostumusta', $locale) }}</li>
    <li>{{ aiTrans('Emme käsittele tietoja Euroopan talousalueen ulkopuolella ilman suostumusta', $locale) }}</li>
    <li>{{ aiTrans('Markkinointiviestinnässä varmistamme suostumuksen ja peruutusvaihtoehdot.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Turvallisuus', $locale) }}</h3>
<p>
    {{ aiTrans('Käytämme hallinnollisia, organisatorisia ja teknisiä turvatoimia suojataksemme Henkilötietoja luvattomalta pääsyltä, paljastamiselta, muuttamiselta, häviämiseltä, väärinkäytöltä tai vahingoittumiselta. Kolmansille osapuolille jaettaessa varmistamme, että ne ylläpitävät samoja tietosuojan tasoja, ja asetamme sopimusvelvoitteet tietojen käsittelyyn yksinomaan ja turvallisesti tämän käytännön mukaisesti.', $locale) }}
</p>
<p>
    {{ aiTrans('Jos epäillään, että yhteydenpito kanssamme on vaarantunut, Vierailijat, Käyttäjät tai Kumppanit tulisi ilmoittaa siitä viipymättä. On tärkeää huomata, että huolimatta turvatoimistamme, emme voi taata täydellistä suojaa kolmansien osapuolten hyökkäyksiä vastaan. Käyttäjät tunnustavat siihen liittyvät riskit ja mahdolliset tietomurrot.', $locale) }}
</p>
<h3>{{ aiTrans('5. Evästeet', $locale) }}</h3>
<p>
    {{ aiTrans('Tutustu', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Evästekäytäntöön', $locale) }}</a> {{ aiTrans('saadaksesi yksityiskohtaisia tietoja evästeiden ja seurantateknologioiden tyypeistä, käytön syistä ja siitä, miten ne voidaan hyväksyä tai hylätä.', $locale) }}
</p>
<h3>{{ aiTrans('6. Linkit muihin verkkosivustoihin', $locale) }}</h3>
<p>
    {{ aiTrans('Verkkosivustolla selaamisen aikana Käyttäjät voivat löytää linkkejä ulkopuolisille verkkosivustoille, jotka eivät ole meidän hallinnassamme. Emme ole vastuussa näiden verkkosivustojen sisällöstä tai tietosuojakäytännöistä. Käyttäjiä kehotetaan tarkistamaan näiden verkkosivustojen ja kolmansien osapuolien palvelujen tietosuojakäytännöt ennen Henkilötietojen paljastamista.', $locale) }}
</p>
<h3>{{ aiTrans('7. Säilytys ja Poistaminen', $locale) }}</h3>
<p>
    {{ aiTrans('Tietoja, mukaan lukien Henkilötietoja, ei säilytetä pidempään kuin on tarpeen. Vierailijat ja/tai Käyttäjät, joilla on aktiivisia tilejä, ovat vastuussa tietojen poistamisesta ajallaan. Tilin tai yhteistyön päättymisen jälkeen Sivustolla ja/tai Palveluissa kerätyt Henkilötiedot poistetaan sovellettavien lakien ja sisäisten käytäntöjemme mukaisesti.', $locale) }}
</p>
<p>
    {{ aiTrans('Henkilötietojen käsittelyn suostumuksen peruutus voi rajoittaa pääsyä joihinkin tai kaikkiin pyydettyihin Palveluihin ilman, että siihen liittyy valituksia tai pidätyksiä.', $locale) }}
</p>
<h3>{{ aiTrans('8. Oikeutesi', $locale) }}</h3>
<p>{{ aiTrans('Käyttäjillä on erityisiä oikeuksia omiin Henkilötietoihinsa liittyen:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Oikeus pääsyyn', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Vahvistaa, käsitelläänkö Henkilötietojasi', $locale) }}</li>
    <li>{{ aiTrans('Päästä käsiksi Henkilötietoihisi ja niihin liittyviin tietoihin', $locale) }}</li>
    <li>{{ aiTrans('Tietoja käsittelyn tarkoituksista, kategorioista, vastaanottajista, säilytyksen kestosta, oikeuksista ja olemassa olevista profiileista', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Oikeus oikaisuun', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Korjata virheelliset Henkilötiedot', $locale) }}</li>
    <li>{{ aiTrans('Täyttää puutteelliset Henkilötiedot', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Oikeus poistoon', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Pyytää Henkilötietojen poistamista tietyissä olosuhteissa', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Oikeus käsittelyn rajoittamiseen', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Saada käsittelyn rajoitus tietyissä olosuhteissa', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Oikeus tietojen siirrettävyyteen', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Saada Henkilötiedot jäsennellyssä ja koneellisesti luettavassa muodossa', $locale) }}</li>
    <li>{{ aiTrans('Siirtää Henkilötiedot toiselle rekisterinpitäjälle', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Oikeus vastustaa', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Vastustaa käsittelyä, joka perustuu laillisiin etuihin tai suoraan markkinointiin', $locale) }}</li>
    <li>{{ aiTrans('Keskeyttää käsittely, ellei ole päteviä ja/tai laillisia syitä', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Oikeus peruuttaa suostumus', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Peruuttaa suostumus Henkilötietojen käsittelyyn milloin tahansa', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Mainos- ja markkinointimateriaalit', $locale) }}</h3>
<p>
    {{ aiTrans('Suostumus pyydetään Henkilötietojen ja yhteystietojen käyttöön mainos- ja markkinointimateriaalien toimittamiseksi. Suostumuksen peruutus on mahdollista lähettämällä kirjallinen ilmoitus annettuun sähköpostiosoitteeseen.', $locale) }}
</p>
<h3>{{ aiTrans('10. Hyväksyntä tästä käytännöstä', $locale) }}</h3>
<p>
    {{ aiTrans('Käyttämällä Sivustoa ja/tai Palveluja, Vierailijoiden, Käyttäjien ja/tai Kumppaneiden katsotaan lukeneen ja hyväksyneen tämän käytännön. Mahdolliset erimielisyydet merkitsevät luopumista alustamme käytöstä. Pidätämme oikeuden muuttaa käytäntöä ja Käyttäjiä kehotetaan tarkistamaan päivityksiä säännöllisesti. Jatkuva käyttö päivitysten jälkeen merkitsee hyväksyntää.', $locale) }}
</p>
<h3>{{ aiTrans('11. Lakisääteinen velvollisuus paljastaa Henkilötiedot', $locale) }}</h3>
<p>
    {{ aiTrans('Henkilötiedot voidaan paljastaa ilman ennakkosuostumusta, jos uskomme, että se on tarpeen henkilöllisyyden vahvistamiseksi, yhteyden ottamiseksi tai oikeudellisten menettelyjen aloittamiseksi epäiltyjä oikeuksien tai omaisuuden loukkauksia vastaan. Paljastaminen tehdään lain vaatimuksesta.', $locale) }}
</p>
<h3>{{ aiTrans('12. Tietosuojavastaava', $locale) }}</h3>
            <p>
                {{ aiTrans('Tietosuoja- ja tietosuoja-asioissa voi olla yhteydessä nimettyyn "Tietosuojavastaavaan" sähköpostilla', $locale) }} <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
    </div>
</div>
@endsection
