@extends('layouts.app')
@section('title', $website_title .' | Datenschutzrichtlinie')
@php( $meta_description = "Erfahren Sie, wie ". $website_title." Ihre persönlichen Daten schützt. Unsere Datenschutzrichtlinie beschreibt die Maßnahmen, die wir ergreifen, um Sicherheit und Transparenz Ihrer Informationen zu gewährleisten.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>DATENSCHUTZRICHTLINIE</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Einführung', $locale) }}</h3>
<p>
    {{ aiTrans('Diese Erklärung beschreibt die von', $locale) }} {{ $website_title }} ("{{ aiTrans('wir', $locale) }}," "{{ aiTrans('uns', $locale) }}," "{{ aiTrans('unser', $locale) }}")
    {{ aiTrans('verfolgte Datenschutzrichtlinie in Bezug auf unsere Produkte und Dienstleistungen (die "Dienstleistungen") und', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Website', $locale) }}</a>
    {{ aiTrans('("Website")', $locale) }}. {{ aiTrans('Der Schutz Ihrer Privatsphäre und die Vertraulichkeit Ihrer Informationen sind für uns von entscheidender Bedeutung, wenn wir unsere Dienstleistungen bereitstellen und die Website betreiben.', $locale) }}
</p>
<p>
    {{ aiTrans('Unsere Dienstleistungen und die Website können Links zu Websites und Dienstleistungen Dritter enthalten. Wir sind nicht für die Datenschutzpraktiken dieser Dritten verantwortlich. Wir empfehlen Ihnen, deren Datenschutzrichtlinien zu überprüfen, bevor Sie deren Dienste nutzen.', $locale) }}
</p>
<p>
    {{ aiTrans('Alle von uns im Zusammenhang mit unseren Dienstleistungen erhobenen Informationen werden vertraulich behandelt. Wir verwenden technische, sicherheitsrelevante und organisatorische Maßnahmen, um personenbezogene Daten (wie nachstehend definiert) vor unbefugter Verarbeitung, versehentlichem Verlust, Zerstörung, Diebstahl oder Offenlegung zu schützen.', $locale) }}
</p>
<p>
    {{ aiTrans('Wenn Sie Informationen über unsere Website übermitteln, werden Sie möglicherweise aufgefordert, personenbezogene Daten wie Ihren Namen, Ihre E-Mail-Adresse, Telefonnummer, Ihr Geburtsdatum und verschiedene Identifikationsdetails anzugeben. Diese Informationen können unter anderem zur Identitätsprüfung, Verwaltung, technischen Unterstützung und zur Erfüllung vertraglicher und gesetzlicher Verpflichtungen verwendet werden. Wir können Ihnen wichtige Details über Benachrichtigungen mitteilen und mit Ihrer Zustimmung Informationen zu Produkten und Dienstleistungen per SMS, E-Mail usw. bereitstellen. Sie haben die Möglichkeit, Ihre Benachrichtigungseinstellungen zu verwalten und sich von bestimmten Mitteilungen abzumelden.', $locale) }}
</p>
<h3>{{ aiTrans('2. Website; Besucher und Nutzer', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Allgemeines', $locale) }}</h4>
<p>
    {{ aiTrans('Dieser Abschnitt beschreibt die spezifische Datenerhebung für verschiedene Gruppen: Website-Besucher ("Besucher"), Nutzer ("Nutzer") und Geschäftspartner (zusammen "Partner"). Personenbezogene Daten umfassen IP-Adresse, Name, Kontaktdaten und Informationen zu unserer Geschäftsbeziehung, wie in den geltenden Datenschutzbestimmungen definiert.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Datenerhebung und -nutzung', $locale) }}</h4>
<p>
    {{ aiTrans('Durch den Besuch der Website stimmen Sie der Erhebung und Nutzung Ihrer personenbezogenen Daten zu. Falls Sie mit diesen Bedingungen nicht einverstanden sind, sollten Sie die Website nicht nutzen. Wir können Daten über Seitenaufrufe, IP-Adressen und Cookies erfassen. Darüber hinaus verarbeiten wir Daten, die freiwillig durch Formulare und Registrierungen übermittelt wurden.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Zweck der Verarbeitung personenbezogener Daten', $locale) }}</h4>
<p>
    {{ aiTrans('Wir verarbeiten personenbezogene Daten, um unsere Website und Dienstleistungen zu verbessern, zu verstehen und zu personalisieren. Dazu gehören die Verbesserung der Genauigkeit, die Kommunikation über Dienstleistungen, die Unterstützung, vertragliche Verpflichtungen und die Zusammenarbeit mit Partnern. Ihre Einwilligung oder eine gesetzliche Grundlage ist erforderlich, um jegliche Verarbeitung zu ermöglichen.', $locale) }}
</p>
<p>{{ aiTrans('Im Folgenden sind die Zwecke und die Rechtsgrundlage für die Verarbeitung personenbezogener Daten beschrieben:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registrierung als Kontoinhaber', $locale) }}</td>
            <td>{{ aiTrans('Ihre Einwilligung; Erfüllung von Dienstleistungen oder vertraglichen Verpflichtungen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Bereitstellung und Nutzung der Dienstleistungen', $locale) }}</td>
            <td>{{ aiTrans('Erfüllung von Dienstleistungen oder vertraglichen Verpflichtungen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Betriebliche Aktualisierungen', $locale) }}</td>
            <td>{{ aiTrans('Erfüllung von Dienstleistungen oder vertraglichen Verpflichtungen', $locale) }}</td>
        </tr>






        <tr>
            <td>{{ aiTrans('Beantwortung von Anfragen und Bereitstellung von Support', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen oder Erbringung von Dienstleistungen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Personalisierte Dienstleistungen, Werbung und Marketing', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen oder Ihre Einwilligung', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Verbesserung und Angebot neuer Dienstleistungen', $locale) }}</td>
            <td>{{ aiTrans('Einwilligung und berechtigte Interessen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Versand von Werbe- und Marketingmaterialien', $locale) }}</td>
            <td>{{ aiTrans('Ihre Einwilligung', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse der Effektivität von Marketingkampagnen', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen oder Einwilligung', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Durchführung verschiedener Support-Aktivitäten', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen oder Erbringung von Dienstleistungen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse, einschließlich statistischer Analyse', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Schutz von Interessen, Rechten und Eigentum', $locale) }}</td>
            <td>{{ aiTrans('Berechtigte Interessen oder gesetzliche Verpflichtungen', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Weitergabe personenbezogener Daten', $locale) }}</h4>
<p>
    {{ aiTrans('Wir können Informationen mit Dienstleistern, Partnern und Auftragnehmern teilen. Für Besucher und Nutzer in der Europäischen Datenregion erfolgt die Datenverarbeitung in Übereinstimmung mit der DSGVO und den geltenden Datenschutzgesetzen.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partner', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Allgemeines', $locale) }}</h4>
<p>
    {{ aiTrans('Um Dienstleistungen bereitzustellen und mit Partnern zusammenzuarbeiten, erfassen und verarbeiten wir bestimmte Arten von Daten. Partner sind für ihre eigenen Daten verantwortlich, und wir können darauf über sichere Methoden zugreifen.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Verarbeitung personenbezogener Daten', $locale) }}</h4>
<p>
    {{ aiTrans('Wir verlassen uns auf die Einwilligung der Partner oder berechtigte Interessen zur Verarbeitung personenbezogener Daten. Es können aggregierte Daten erstellt werden, um Entwicklung und Qualitätsverbesserung zu fördern.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Verantwortlicher/Auftragsverarbeiter', $locale) }}</h4>
<p>{{ aiTrans('Wir können je nach Art der Daten entweder als Verantwortlicher oder als Auftragsverarbeiter agieren:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Daten von Besuchern/Nutzern: Verantwortlicher', $locale) }}</li>
    <li>{{ aiTrans('Daten von Partnern: Auftragsverarbeiter', $locale) }}</li>
    <li>{{ aiTrans('Alle Daten werden sicher gehostet und entsprechen den höchsten Sicherheitsstandards. Wir implementieren physische, technische und organisatorische Schutzmaßnahmen.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Schutz von Drittanbieterdaten', $locale) }}</h4>
<p>{{ aiTrans('Wenn die Dienstleistungen die Verarbeitung personenbezogener Daten auf einer Drittanbieter-Plattform beinhalten:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Agieren wir als Auftragsverarbeiter', $locale) }}</li>
    <li>{{ aiTrans('Befolgen wir die Anweisungen des Drittanbieters', $locale) }}</li>
    <li>{{ aiTrans('Implementieren wir Sicherheitsmaßnahmen', $locale) }}</li>
    <li>{{ aiTrans('Melden wir Datenschutzverletzungen', $locale) }}</li>
    <li>{{ aiTrans('Beauftragen wir keine Subunternehmer ohne Zustimmung', $locale) }}</li>
    <li>{{ aiTrans('Verarbeiten wir keine Daten außerhalb des Europäischen Wirtschaftsraums ohne Zustimmung', $locale) }}</li>
    <li>{{ aiTrans('Für elektronische Marketingkommunikation stellen wir sicher, dass eine Einwilligung vorliegt und eine Abmeldung möglich ist.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Sicherheit', $locale) }}</h3>


<p>
    {{ aiTrans('Wir setzen administrative, organisatorische und technische Schutzmaßnahmen ein, um personenbezogene Daten vor unbefugtem Zugriff, Offenlegung, Änderung, Verlust, Missbrauch oder Schäden zu schützen. Bei der Weitergabe von Daten an Dritte stellen wir sicher, dass sie dieselben Datenschutzstandards einhalten, und vertragliche Verpflichtungen werden für eine sichere Verarbeitung im Einklang mit dieser Richtlinie festgelegt.', $locale) }}
</p>
<p>
    {{ aiTrans('Falls angenommen wird, dass die Interaktion mit uns kompromittiert wurde, sollten Besucher, Benutzer oder Partner uns unverzüglich benachrichtigen. Es ist wichtig zu beachten, dass wir trotz unserer Sicherheitsmaßnahmen keine vollständige Immunität gegen Angriffe Dritter garantieren können. Die Benutzer erkennen die inhärenten Risiken und möglichen Verstöße an.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Weitere Informationen zu den Arten von Cookies und Tracking-Technologien, die auf der Website verwendet werden, deren Zweck und Möglichkeiten zur Zustimmung oder Ablehnung finden Sie in unserer', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Cookie-Richtlinie', $locale) }}</a>.
</p>
<h3>{{ aiTrans('6. Links zu anderen Websites', $locale) }}</h3>
<p>
    {{ aiTrans('Während der Nutzung der Website können Benutzer auf externe Links stoßen, die außerhalb unserer Kontrolle liegen. Wir sind nicht für den Inhalt oder die Datenschutzrichtlinien dieser Websites verantwortlich. Benutzer werden aufgefordert, die Datenschutzrichtlinien solcher Websites und Drittanbieterdienste zu überprüfen, bevor sie personenbezogene Daten offenlegen.', $locale) }}
</p>
<h3>{{ aiTrans('7. Speicherung und Löschung', $locale) }}</h3>
<p>
    {{ aiTrans('Daten, einschließlich personenbezogener Daten, werden nicht länger als erforderlich gespeichert. Besucher und/oder Benutzer mit aktiven Konten sind für die rechtzeitige Löschung ihrer Daten verantwortlich. Nach Beendigung eines Kontos oder einer Partnerschaft werden die über die Website und/oder Dienstleistungen gesammelten personenbezogenen Daten gemäß den geltenden Gesetzen und unseren internen Richtlinien gelöscht.', $locale) }}
</p>
<p>
    {{ aiTrans('Der Widerruf der Einwilligung zur Verarbeitung personenbezogener Daten kann den Zugang zu einigen oder allen angeforderten Dienstleistungen einschränken, ohne dass Ansprüche oder Streitigkeiten entstehen.', $locale) }}
</p>
<h3>{{ aiTrans('8. Ihre Rechte', $locale) }}</h3>
<p>{{ aiTrans('Benutzer haben spezifische Rechte in Bezug auf ihre personenbezogenen Daten:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Recht auf Zugang', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Bestätigung, ob personenbezogene Daten verarbeitet werden', $locale) }}</li>
    <li>{{ aiTrans('Zugang zu personenbezogenen Daten und damit verbundenen Informationen', $locale) }}</li>
    <li>{{ aiTrans('Informationen zu Verarbeitungszwecken, Kategorien, Empfängern, Speicherdauer, Rechten und dem Vorhandensein von Profiling', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Recht auf Berichtigung', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Berichtigung ungenauer personenbezogener Daten', $locale) }}</li>
    <li>{{ aiTrans('Vervollständigung unvollständiger personenbezogener Daten', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Recht auf Löschung', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Antrag auf Löschung personenbezogener Daten unter bestimmten Umständen', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Recht auf Einschränkung der Verarbeitung', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Einschränkung der Verarbeitung unter bestimmten Umständen', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Recht auf Datenübertragbarkeit', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Erhalt personenbezogener Daten in einem strukturierten und maschinenlesbaren Format', $locale) }}</li>
    <li>{{ aiTrans('Übermittlung personenbezogener Daten an einen anderen Verantwortlichen', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Widerspruchsrecht', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Widerspruch gegen die Verarbeitung aufgrund berechtigter Interessen oder Direktmarketing', $locale) }}</li>
    <li>{{ aiTrans('Beendigung der Verarbeitung, es sei denn, es liegen zwingende und/oder gesetzliche Gründe vor', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Recht auf Widerruf der Einwilligung', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Widerruf der Einwilligung zur Verarbeitung personenbezogener Daten jederzeit', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Werbe- und Marketingmaterialien', $locale) }}</h3>
<p>
    {{ aiTrans('Die Einwilligung wird eingeholt, um personenbezogene Daten und Kontaktdetails für die Bereitstellung von Werbe- und Marketingmaterialien zu nutzen. Der Widerruf der Einwilligung ist durch eine schriftliche Mitteilung an die angegebene E-Mail-Adresse möglich.', $locale) }}
</p>
<h3>{{ aiTrans('10. Akzeptanz dieser Richtlinie', $locale) }}</h3>
<p>
    {{ aiTrans('Durch die Nutzung der Website und/oder der Dienstleistungen gelten Besucher, Benutzer und/oder Partner als mit dieser Richtlinie einverstanden. Eine Nichtübereinstimmung bedeutet, dass die Nutzung der Plattform unterlassen werden sollte. Wir behalten uns das Recht vor, die Richtlinie zu ändern, und Benutzer werden ermutigt, regelmäßig auf Aktualisierungen zu prüfen. Die fortgesetzte Nutzung nach Änderungen bedeutet Akzeptanz.', $locale) }}
</p>
<h3>{{ aiTrans('11. Gesetzliche Verpflichtung zur Offenlegung personenbezogener Daten', $locale) }}</h3>
<p>
    {{ aiTrans('Personenbezogene Daten können ohne vorherige Zustimmung offengelegt werden, wenn der begründete Verdacht besteht, dass dies erforderlich ist, um die Identität festzustellen, Kontakt aufzunehmen oder rechtliche Schritte gegen Personen einzuleiten, die verdächtigt werden, Rechte oder Eigentum zu verletzen. Die Offenlegung erfolgt, wenn dies gesetzlich vorgeschrieben ist.', $locale) }}
</p>
<h3>{{ aiTrans('12. Datenschutzbeauftragter', $locale) }}</h3>
<p>
    {{ aiTrans('Für Datenschutz- und Datenschutzfragen kann der "Datenschutzbeauftragte" unter folgender E-Mail-Adresse kontaktiert werden:', $locale) }} <span>info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>






        </div>
    </div>
</div>
@endsection
