@extends('layouts.app')
@section('title', $website_title .' | Privatlivspolitik')
@php( $meta_description = "Find ud af, hvordan ". $website_title." beskytter dine personlige data. Vores privatlivspolitik beskriver de foranstaltninger, vi tager for at sikre sikkerheden og gennemsigtigheden af dine oplysninger.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>PRIVATLIVSPOLITIK</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Introduktion', $locale) }}</h3>
<p>
    {{ aiTrans('Denne erklæring beskriver privatlivspolitikken vedtaget af', $locale) }} {{ $website_title }} ("{{ aiTrans('vi', $locale) }}," "{{ aiTrans('vores', $locale) }}," "{{ aiTrans('eller', $locale) }}")
    {{ aiTrans('vedrørende vores produkter og tjenester (de "Tjenester") og', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('webstedet', $locale) }}</a>
    {{ aiTrans('("Webstedet")', $locale) }}. {{ aiTrans('At beskytte dit privatliv og fortroligheden af dine oplysninger er vigtigt for os, når vi leverer vores Tjenester og driver Webstedet.', $locale) }}
</p>
<p>
    {{ aiTrans('Vore Tjenester og Websted kan indeholde links til tredjepartswebsteder og -tjenester. Vi er ikke ansvarlige for privatlivsmetoderne hos disse tredjepartsaktører. Vi anbefaler, at du gennemgår deres privatlivspolitikker, før du benytter dem.', $locale) }}
</p>
<p>
    {{ aiTrans('Alle oplysninger, der indsamles af os i forbindelse med vores Tjenester, behandles som fortrolige. Vi bruger tekniske, sikkerhedsmæssige og organisatoriske foranstaltninger til at beskytte Personlige Oplysninger (som defineret nedenfor) mod uautoriseret behandling, utilsigtet tab, ødelæggelse, skade, tyveri eller offentliggørelse.', $locale) }}
</p>
<p>
    {{ aiTrans('Når du indsender dine oplysninger via vores websted, kan du blive bedt om at give personlige oplysninger, såsom dit navn, e-mailadresse, telefonnummer, fødselsdato og forskellige identifikationsoplysninger. Disse oplysninger kan bruges til andre formål, såsom at verificere identitet, administrere oplysninger, yde teknisk support og opfylde kontraktmæssige og lovmæssige forpligtelser. Vi kan kommunikere vigtige oplysninger via meddelelser og, med dit samtykke, sende oplysninger om produkter og tjenester via SMS, e-mail osv. Du har mulighed for at administrere dine meddelelsespræferencer og framelde dig visse kommunikationer.', $locale) }}
</p>
<h3>{{ aiTrans('2. Websted; Besøgende og Brugere', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Generelt', $locale) }}</h4>
<p>
    {{ aiTrans('Denne sektion beskriver specifikationerne for dataindsamling fra forskellige grupper: besøgende på webstedet ("Besøgende"), brugere ("Brugere") og forretningspartnere (samlet kaldet "Partnere"). Personlige Oplysninger omfatter IP-adresse, navn, kontaktoplysninger og oplysninger om forholdet til os, som defineret af de gældende databeskyttelsesbestemmelser.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Indsamling og Brug', $locale) }}</h4>
<p>
    {{ aiTrans('Ved at besøge Webstedet giver du samtykke til indsamling og brug af dine Personlige Oplysninger. Manglende samtykke til disse betingelser skal forhindre dig i at besøge Webstedet. Vi kan indsamle oplysninger via sidevisningsaktivitet, IP-adresser og cookies. Derudover behandler vi data, der frivilligt gives gennem formularer og registreringer.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Formål med Behandling af Personlige Oplysninger', $locale) }}</h4>
<p>
    {{ aiTrans('Vi behandler Personlige Oplysninger for at forbedre, forstå og personalisere vores Websted og Tjenester. Dette omfatter forbedring af præcision, kommunikation om Tjenester, support, kontraktmæssige forpligtelser og samarbejde med partnere. Samtykke eller en lovlig grund er essentiel for enhver behandling.', $locale) }}
</p>
<p>{{ aiTrans('Følgende beskriver formålene og den lovlige grund for behandlingen af Personlige Oplysninger:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registrering som kontoholder', $locale) }}</td>
            <td>{{ aiTrans('Dit samtykke; udførelse af Tjenester eller kontraktmæssige forpligtelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Levering og brug af Tjenester', $locale) }}</td>
            <td>{{ aiTrans('Udførelse af Tjenester eller kontraktmæssige forpligtelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Driftsopdateringer', $locale) }}</td>
            <td>{{ aiTrans('Udførelse af Tjenester eller kontraktmæssige forpligtelser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Besvarelse af forespørgsler og levering af support', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser eller udførelse af Tjenester', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Tjenester, reklame og målrettet markedsføring', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser eller dit samtykke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Forbedring og tilbud af nye Tjenester', $locale) }}</td>
            <td>{{ aiTrans('Samtykke og legitime interesser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Afsendelse af reklame- og markedsføringsmateriale', $locale) }}</td>
            <td>{{ aiTrans('Dit samtykke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse af markedsføringskampagners effektivitet', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser eller samtykke', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Udførelse af forskellige supportaktiviteter', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser eller udførelse af Tjenester', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analyse, herunder statistisk analyse', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Beskyt interesser, rettigheder og ejendom', $locale) }}</td>
            <td>{{ aiTrans('Legitime interesser eller lovpligtige forpligtelser', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Deling af Personlige Oplysninger', $locale) }}</h4>
<p>
    {{ aiTrans('Vi kan dele oplysninger med tjenesteudbydere, Partnere og kontraherede parter. For Besøgende og Brugere i den Europæiske Databeskyttelsesregion er databehandlingen i overensstemmelse med GDPR og gældende Databeskyttelseslove.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partnere', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Generelt', $locale) }}</h4>
<p>
    {{ aiTrans('For at levere Tjenester og samarbejde med Partnere indsamler og behandler vi specifikke typer data. Partnere er ansvarlige for deres data, og vi kan få adgang til dem via sikre metoder.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Behandling af Personlige Oplysninger', $locale) }}</h4>
<p>
    {{ aiTrans('Vi stoler på Partneres samtykke eller legitime interesser for at behandle Personlige Oplysninger. Aggererede Data kan oprettes til udvikling og forbedring af kvalitet.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Dataansvarlig/Behandler', $locale) }}</h4>
<p>{{ aiTrans('Vi kan handle som Dataansvarlig eller Data Behandler afhængigt af hvilken type data:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Besøgende/Bruger Data: Dataansvarlig', $locale) }}</li>
    <li>{{ aiTrans('Partner Data: Behandler', $locale) }}</li>
    <li>{{ aiTrans('Alle data er hostet sikkert og følger de højeste sikkerhedsstandarder. Vi implementerer fysiske, tekniske og organisatoriske beskyttelsesforanstaltninger.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Beskyttelse af Tredjepartsdata', $locale) }}</h4>
<p>{{ aiTrans('Hvis Tjenesterne involverer behandling af Personlige Oplysninger på en tredjepartsplatform:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Vi agerer som Data Behandler', $locale) }}</li>
    <li>{{ aiTrans('Følge tredjeparts instruktioner', $locale) }}</li>
    <li>{{ aiTrans('Implementere sikkerhedsforanstaltninger', $locale) }}</li>
    <li>{{ aiTrans('Underrette om databrud', $locale) }}</li>
    <li>{{ aiTrans('Ingen underleverandører uden samtykke', $locale) }}</li>
    <li>{{ aiTrans('Ikke behandle data uden for det Europæiske Økonomiske Samarbejdsområde uden samtykke', $locale) }}</li>
    <li>{{ aiTrans('For elektronisk markedsføringskommunikation, sikrer vi samtykke og opsigelsesmuligheder.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Sikkerhed', $locale) }}</h3>
<p>
    {{ aiTrans('Vi bruger administrative, organisatoriske og tekniske foranstaltninger for at beskytte Personlige Oplysninger mod uautoriseret adgang, offentliggørelse, ændring, tab, misbrug eller skade. Når data deles med tredjeparter, sikrer vi, at de opretholder samme databeskyttelsesstandarder, og der etableres kontraktlige forpligtelser for at sikre, at behandlingen er i overensstemmelse med denne politik.', $locale) }}
</p>
<p>
    {{ aiTrans('Hvis det er mistanke om, at en interaktion med os er blevet kompromitteret, skal Besøgende, Brugere eller Partnere straks informere os. Det er vigtigt at bemærke, at på trods af vores sikkerhedsforanstaltninger, kan vi ikke garantere fuldstændig beskyttelse mod tredjepartsangreb. Brugere anerkender de iboende risici og mulige overtrædelser.', $locale) }}
</p>
<h3>{{ aiTrans('5. Cookies', $locale) }}</h3>
<p>
    {{ aiTrans('Se vores', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Cookiespolitik', $locale) }}</a> {{ aiTrans('for detaljerede oplysninger om de cookies og sporings-teknologier, der anvendes på Webstedet, formålene med brugen og hvordan man accepterer eller afviser dem.', $locale) }}
</p>
<h3>{{ aiTrans('6. Links til Andre Websteder', $locale) }}</h3>
<p>
    {{ aiTrans('Under navigation på Webstedet kan Brugere finde links til eksterne websteder, som vi ikke har kontrol over. Vi påtager os ikke ansvar for indholdet eller privatlivspolitikkerne for disse websteder. Brugere opfordres til at gennemgå privatlivspolitikkerne for sådanne websteder og tredjepartstjenester, før de afslører personlige oplysninger.', $locale) }}
</p>
<h3>{{ aiTrans('7. Opbevaring og Sletning', $locale) }}</h3>
<p>
    {{ aiTrans('Data, herunder Personlige Oplysninger, opbevares ikke længere end nødvendigt. Besøgende og/eller Brugere med aktive konti er ansvarlige for rettidig sletning af data. Efter opsigelse af en konto eller partnerskab, vil de Personlige Oplysninger indsamlet via Webstedet og/eller Tjenesterne blive slettet i henhold til gældende lovgivning og vores interne politikker.', $locale) }}
</p>
<p>
    {{ aiTrans('Tilbagetrækning af samtykke til behandling af Personlige Oplysninger kan begrænse adgangen til visse eller alle anmodede Tjenester, uden at der kan rejses krav eller indsigelser.', $locale) }}
</p>
<h3>{{ aiTrans('8. Dine Rettigheder', $locale) }}</h3>
<p>{{ aiTrans('Brugere har specifikke rettigheder i forhold til deres Personlige Oplysninger:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Ret til Adgang', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Bekræfte om Personlige Oplysninger behandles', $locale) }}</li>
    <li>{{ aiTrans('Få adgang til Personlige Oplysninger og relaterede oplysninger', $locale) }}</li>
    <li>{{ aiTrans('Oplysninger om formål med behandling, kategorier, modtagere, opbevaringsperiode, rettigheder og eksistens af profiler', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Ret til Berigtigelse', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Berigtige unøjagtige Personlige Oplysninger', $locale) }}</li>
    <li>{{ aiTrans('Færdiggøre ufuldstændige Personlige Oplysninger', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Ret til Sletning', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Anmode om sletning af Personlige Oplysninger under specifikke omstændigheder', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Ret til Begrænsning af Behandling', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Få begrænsning af behandlingen under specifikke omstændigheder', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Ret til Dataportabilitet', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Modtage Personlige Oplysninger i et struktureret og maskinlæsbart format', $locale) }}</li>
    <li>{{ aiTrans('Overføre Personlige Oplysninger til en anden dataansvarlig', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Ret til Indsigelse', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Modsætte behandling baseret på legitime interesser eller direkte markedsføring', $locale) }}</li>
    <li>{{ aiTrans('Stoppe behandlingen, medmindre der er tvingende og/eller lovgivningsmæssige årsager', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Ret til at Tilbagekalde Samtykke', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Tilbagetrække samtykke til behandling af Personlige Oplysninger når som helst', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Reklame- og Markedsføringsmateriale', $locale) }}</h3>
<p>
    {{ aiTrans('Samtykke indhentes til brug af Personlige Oplysninger og kontaktoplysninger til at sende reklame- og markedsføringsmateriale. Tilbagetrækning af samtykke er mulig ved at sende en skriftlig meddelelse til den oplyste e-mailadresse.', $locale) }}
</p>
<h3>{{ aiTrans('10. Accept af denne Politik', $locale) }}</h3>
<p>
    {{ aiTrans('Ved at bruge Webstedet og/eller Tjenesterne antages det, at Besøgende, Brugere og/eller Partnere har læst og accepteret denne Politik. Enhver uenighed medfører afståelse fra at bruge platformen. Vi forbeholder os retten til at ændre Politikken, og Brugere opfordres til at tjekke opdateringer regelmæssigt. Ved fortsat brug efter ændringerne anses det som accept.', $locale) }}
</p>
<h3>{{ aiTrans('11. Lovpligtig Afsløring af Personlige Oplysninger', $locale) }}</h3>
<p>
    {{ aiTrans('Personlige Oplysninger kan afsløres uden forudgående samtykke, hvis der er en mistanke om, at det er nødvendigt at fastslå identitet, kontakte eller påbegynde lovgivningsmæssige procedurer mod personer, der mistænkes for at krænke rettigheder eller ejendom. Afsløring vil ske, når det kræves ved lov.', $locale) }}
</p>
<h3>{{ aiTrans('12. Data Protection Officer', $locale) }}</h3>
            <p>
                For spørgsmål vedrørende privatlivets fred og databeskyttelse, kan en udpeget "Data Protection Officer" kontaktes via e-mail <span >info{{ '@'.$website_title }}</span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
    </div>
</div>
@endsection
