<x-ui::form :route="$route" :name="$formName" :breadcrumbs="$formBreadCrumbs" :files="true">
    <div class="row">
        <div class="col-md-6">
            <x-ui::form.input name="first_name" :label="__('First Name')" required/>
        </div>
        <div class="col-md-6">
            <x-ui::form.input name="last_name" :label="__('Last Name')" required/>
        </div>

        <div class="col-md-6">
            <x-ui::form.input name="phone" :label="__('Phone')" required/>
        </div>
        <div class="col-md-6">
            <x-ui::form.input name="email" :label="__('Email')" required/>
        </div>
        <div class="col-md-6">
            <x-ui::form.input name="password" type="password" :label="__('Password')"/>
        </div>
        <div class="col-md-6">
            <x-ui::form.input name="password_confirmation" type="password"
                              :label="__('Password Confirmation')"/>
        </div>

        <div class="col-md-6">
            <x-ui::form.select name="lang"
                               data-control="select2"
                               :options="['ar'=>__('Ar'),'en'=>__('En')]"
                               :selected="$model?->lang"
                               :label="__('Lang')"/>
        </div>


        <div class="col-md-6">
            <x-ui::form.select name="status"
                               data-control="select2"
                               :options="[
                                'pending'=>__('Pending'),
                                'banned'=>__('Banned'),
                                'active'=>__('Active'),
                                ]"
                               :selected="$model?->status"
                               :label="__('Status')"/>
        </div>
        <div class="col-md-6">
            <x-ui::form.select name="city_id"
                               :options="$cities"
                               data-control="select2"
                               :selected="$model?->city_id"
                               :label="__('City')"/>
        </div>

        <x-ui::form.toggle name="notify" :label="__('notify')"/>

    </div>

    <div class="row">
        <div class="col-md-3">
            <x-ui::form.image name="avatar" :value="$model?->getFirstMediaUrl('avatar')"
                              :label="__('Avatar')"/>
        </div>

        <div class="col-md-3">
            <x-ui::form.image name="business_card"
                              :value="$model?->getFirstMediaUrl('business_card')"
                              :label="__('Company Image')"/>
        </div>

    </div>


    <x-slot:header>

    </x-slot:header>
    <x-slot:scripts>
    </x-slot:scripts>
</x-ui::form>
