<x-app-layout>
    <div class="container d-flex min-vh-100 align-items-center">
        <div class="w-50 p-4">
            <div>
                <img class="h-12 w-auto mb-4" src="https://tailwindui.com/img/logos/workflow-mark-indigo-600.svg" alt="Workflow">
                <h2 class="h4 text-primary font-weight-bold mb-2">Create a new account</h2>
                <p>
                    Or
                    <a href="/login" class="text-indigo-600">sign in to your existing account</a>
                </p>
            </div>

            <div class="mt-3">
                @if ($errors->any())
                    <ul class="list-unstyled text-danger">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                @endif

                <form action="{{ route('register') }}" method="POST" class="mt-3">
                    @csrf

                    <div class="mb-3">
                        <label for="company" class="form-label">Company Name</label>
                        <input type="text" id="company" name="company" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="domain" class="form-label">Sub domain</label>
                        <div class="input-group">
                            <input type="text" id="domain" name="domain" class="form-control" aria-describedby="domain-append" required>
                            <span class="input-group-text" id="domain-append">.{{ config('tenancy.central_domains')[2] }}</span>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="name" class="form-label">Name</label>
                        <input type="text" id="name" name="name" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">Email address</label>
                        <input type="email" id="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="phone" class="form-label">phone</label>
                        <input type="tel" id="phone" name="phone" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" id="password" name="password" class="form-control" required>
                    </div>

                    <div class="mb-3">
                        <label for="password_confirmation" class="form-label">Confirmation</label>
                        <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" required>
                    </div>

                    <div class="mb-4">
                        <div class="form-check">
                            <input type="checkbox" id="remember-me" name="remember-me" class="form-check-input">
                            <label for="remember-me" class="form-check-label">Remember me</label>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <div class="text-sm">
                            <a href="#" class="text-primary">Forgot your password?</a>
                        </div>
                    </div>

                    <button type="submit" class="btn btn-primary w-100 mt-3">Register</button>
                </form>
            </div>
        </div>

    </div>
</x-app-layout>
