<script src="{{asset('themes/charity/assets/js/intlTelInput.js')}}"></script>
@if(app()->getLocale() == 'ar')
    <style>
        .iti__country-list {
            left: -20px;
        }
    </style>
@endif
<script type="text/javascript">
    $(document).ready(function () {
        let input = document.querySelector("#telephone");
        let intlTel = window.intlTelInput(input, {
            nationalMode: true,
            autoHideDialCode: false,
            formatOnDisplay: false, // SET THIS!!!
            utilsScript: 'https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.0/js/utils.js',
            separateDialCode: false,
            dropdownContainer: null,
            initialCountry: 'auto',
            geoIpLookup: function (callback) {
                $.get('https://ipinfo.io', function () {
                }, "jsonp")
                    .always(function (resp) {
                        let countryCode = (resp && resp.country) ? resp.country : $("#country_code").val();
                        callback(countryCode);
                    });
            },
            onlyCountries: ["EG", "SA"],
            utilsScript: "{{ url('/themes/charity/assets/js/utils.js') }}"
        });

        let handleChange = function () {
            $('#phone-value').val(intlTel.getNumber());
            $("#country_code").val(capitalizeFirstLetter(intlTel.getSelectedCountryData().iso2))
        }
        input.addEventListener("countrychange", function () {
            input.value = '';
            $("#country_code").val(capitalizeFirstLetter(intlTel.getSelectedCountryData().iso2))
            $('#phone-value').val(intlTel.getNumber());
        });

        input.addEventListener('change', handleChange);
        input.addEventListener('keyup', handleChange);
    });

    function capitalizeFirstLetter(str) {
        if (str) {
            return str.toUpperCase();
        }
    }
</script>
