<x-app-layout>
    <div class="container d-flex align-items-center justify-content-center min-vh-100">
        <div class="card w-50 p-4">
            <div class="text-center">
                <img class="mb-4" src="/images/logo.svg" alt="Workflow" style="height: 3rem;">
                <h2 class="h4 mb-3 font-weight-bold">Sign in to your account</h2>
                <p>
                    Or <a href="register" class="text-primary">register your account today!</a>
                </p>
            </div>

            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form method="POST" action="{{ route('login') }}">
                @csrf

                <div class="form-group">
                    <label for="email">Email address</label>
                    <input type="email" class="form-control" id="email" name="email" required>
                </div>

                <div class="form-group">
                    <label for="password">Password</label>
                    <input type="password" class="form-control" id="password" name="password" required>
                </div>

                <div class="d-flex justify-content-between align-items-center mb-4">
                    <div class="form-check">
                        <input type="checkbox" class="form-check-input" id="remember-me" name="remember-me">
                        <label class="form-check-label" for="remember-me">Remember me</label>
                    </div>
                    <a href="/forgot-password" class="text-primary">Forgot your password?</a>
                </div>

                <button type="submit" class="btn btn-primary w-100">Sign in</button>
            </form>
        </div>
        <div class="d-none d-lg-block w-50">
            <img src="https://images.unsplash.com/photo-1600880292203-757bb62b4baf?ixlib=rb-1.2.1&ixid=eyJhcHBfaWQiOjEyMDd9&auto=format&fit=crop&w=1908&q=80" class="img-fluid" alt="">
        </div>
    </div>
</x-app-layout>
