<?php

$allowedDomain = parse_url('https://' . $_SERVER['HTTP_HOST'], PHP_URL_HOST);
$domain = $_GET['domain'] ?? null; // جلب اسم الدومين من URL

if (!$domain) {
    die('Domain is required');
}

// التحقق من تطابق الدومين
if ($domain !== $allowedDomain) {
    die('Invalid domain. Access denied.');
}

$filePath = __DIR__ . '/sitemap.xml'; // مسار ملف السايت ماب في public

// اللغات المدعومة
$languages = [
    '', // اللغة الأساسية (بدون مسار)
    'nl', 'fi', 'is', 'da', 'ar', 'cs', 'de', 'es', 'fr', 'el',
    'hr', 'hu', 'id', 'it', 'ja', 'ko', 'no', 'fil', 'pl', 'pt',
    'ro', 'ru', 'sk', 'sv', 'tr', 'zh'
];

// الروابط الثابتة
$staticUrls = [
    '/about',
];

// إذا كان ملف السايت ماب موجودًا، أوقف تنفيذ السكربت فورًا
if (file_exists($filePath)) {
    die('Sitemap already exists. No changes made.');
}



else {
    // إنشاء ملف جديد إذا لم يكن موجودًا
    $sitemapContent = '<?xml version="1.0" encoding="UTF-8"?>';
    $sitemapContent .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';
    $sitemapContent .= '</urlset>';
    file_put_contents($filePath, $sitemapContent);
}

// إضافة الروابط إلى السايت ماب
$newEntry = '';

// إضافة الروابط لكل لغة
foreach ($languages as $lang) {
    $langPath = $lang ? '/' . $lang : ''; // المسار الخاص بكل لغة (بدون "/" في النهاية)

    // الصفحة الرئيسية لكل لغة
    $newEntry .= '<url>';
    $newEntry .= '<loc>https://' . $domain . $langPath . '</loc>'; // بدون "/" في النهاية
    $newEntry .= '<lastmod>' . date('Y-m-d') . '</lastmod>';
    $newEntry .= '<priority>1.0</priority>';
    $newEntry .= '</url>';

    // الروابط الثابتة لكل لغة
    foreach ($staticUrls as $url) {
        $newEntry .= '<url>';
        $newEntry .= '<loc>https://' . $domain . $langPath . $url . '</loc>';
        $newEntry .= '<lastmod>' . date('Y-m-d') . '</lastmod>';
        $newEntry .= '<priority>0.8</priority>';
        $newEntry .= '</url>';
    }
}

// إدراج الإدخال الجديد قبل نهاية الملف
$sitemapContent = str_replace('</urlset>', $newEntry . '</urlset>', $sitemapContent);

// حفظ التعديلات
file_put_contents($filePath, $sitemapContent);


// إنشاء ملف 11.html فارغ
file_put_contents(__DIR__ . '/11.html', '');


echo 'Sitemap created successfully!';
