<?php

$domain = $_SERVER['HTTP_HOST'];

// اللغات المدعومة
$languages = [
    '', 'nl', 'fi', 'is', 'da', 'ar', 'cs', 'de', 'es', 'fr', 'el',
    'hr', 'hu', 'id', 'it', 'ja', 'ko', 'no', 'fil', 'pl', 'pt',
    'ro', 'ru', 'sk', 'sv', 'tr', 'zh'
];

// الروابط الثابتة التي تريد إضافتها لكل لغة
$staticUrls = [
    '/about',
    // ممكن تضيف هنا: '/contact', '/terms', إلخ
];

header('Content-Type: application/xml');

echo '<?xml version="1.0" encoding="UTF-8"?>';
echo '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">';

// إنشاء كل اللغات والرابط الثابت
foreach ($languages as $lang) {
    $langPath = $lang ? '/' . $lang : '';

    // الصفحة الرئيسية
    echo '<url>';
    echo '<loc>https://' . $domain . $langPath . '</loc>';
    echo '<priority>1.0</priority>';
    echo '</url>';

    // الروابط الثابتة
    foreach ($staticUrls as $url) {
        echo '<url>';
        echo '<loc>https://' . $domain . $langPath . $url . '</loc>';
        echo '<priority>0.8</priority>';
        echo '</url>';
    }
}

echo '</urlset>';
