<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name', 191)->nullable();
            $table->string('first_name', 50)->nullable();
            $table->string('last_name', 50)->nullable();
            $table->string('identification')->nullable();
            $table->string('phone', 191)->unique();
            $table->string('old_phone', 191)->nullable();
            $table->string('email', 50)->nullable()->unique();
            $table->string('password', 255)->nullable();
            $table->string('bank_name', 255)->nullable();
            $table->string('bank_account_name', 255)->nullable();
            $table->string('bank_account_number', 255)->nullable();
            $table->string('iban', 255)->nullable();
            $table->boolean('notify')->default(true);
            $table->boolean('online')->default(false);
            $table->string('lang', 4)->default('ar');
            $table->boolean('is_broker')->default(0);

            $table->boolean('mobile_verify_at')->default(false);
            $table->string('status')->default('pending');//banned,pending,active

            $table->double('lat')->nullable();
            $table->double('lng')->nullable();
            $table->string('address', 255)->nullable();
            $table->timestamp('last_updated_location')->nullable();


            $table->softDeletes();
            $table->rememberToken();
            $table->timestamps();
            $table->timestamp('last_seen')->nullable();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
