<?php

namespace Database\Factories\Core;

use App\Domain\Core\Models\Article;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Domain\Core\Article>
 */
class ArticleFactory extends Factory
{
    protected $model = Article::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $birth = $this->faker->numberBetween(0, 1000);
        $death = $birth + $this->faker->numberBetween(30, 100);

        return [
            'title' => $this->faker->sentence(),
            'body' => $this->faker->text(),
            'place' => $this->faker->country(),
            'lifespan' => "{$birth}-{$death}",
            'tags' => collect(['php', 'ruby', 'java', 'javascript', 'bash'])
                ->random(2)
                ->values()
                ->all(),
        ];
    }
}
