<?php

namespace App\Providers;

use App\Domain\Order\Models\Order;
use App\Domain\Order\Models\WenchRequest;
use App\Domain\Order\Observers\OrderObserver;
use App\Domain\Order\Observers\WenchRequestObserver;
use Illuminate\Auth\Events\Registered;
use Illuminate\Auth\Listeners\SendEmailVerificationNotification;
use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Event;

class EventServiceProvider extends ServiceProvider
{
    /**
     * The event to listener mappings for the application.
     *
     * @var array<class-string, array<int, class-string>>
     */
    protected $listen = [
        Registered::class => [
            SendEmailVerificationNotification::class,
        ],
        'HyperPay\Events\SuccessTransaction' => [
            'App\Listeners\TransactionSuccessListener',
        ],
        'HyperPay\Events\FailTransaction' => [
            'App\Listeners\TransactionFailListener',
        ],
    ];

    /**
     * Register any events for your application.
     *
     * @return void
     */
    public function boot()
    {

    }

    /**
     * Determine if events and listeners should be automatically discovered.
     *
     * @return bool
     */
    public function shouldDiscoverEvents()
    {
        return false;
    }
}
