<?php

namespace App\Http\Resources\API\Driver;

use App\Domain\Order\Actions\OrderCheckStatusAction;
use App\Domain\Order\Models\Order;
use App\Domain\Order\OrderStatus\Enums\AppointmentOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\SparePartOrderStatusEnum;
use App\Domain\Order\OrderStatus\Enums\WenchOrderStatusEnum;
use App\Http\Resources\API\Order\ServiceOrderResource;
use App\Http\Resources\API\Job\OfferResource;
use App\Http\Resources\API\Order\SparePartOrderResource;
use App\Http\Resources\API\Job\SparePartResource;
use App\Http\Resources\API\Core\BranchResource;
use App\Http\Resources\API\Core\BrandResource;
use App\Http\Resources\API\Core\CarTypeResource;
use App\Http\Resources\API\Core\ProblemResource;
use App\Http\Resources\API\User\UserCarResource;
use App\Http\Resources\API\User\UserResource;
use App\Http\Resources\API\User\VendorResource;
use App\Support\Traits\WithPagination;
use Carbon\Carbon;
use HyperPay\Models\Transaction;
use Illuminate\Http\Resources\Json\JsonResource;

class WenchOrderResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {

        return [
            'id' => $this->id,
            'order_num' => $this->order_num,
            'qr_code' => $this->qr_code,
            'qr_code_image' => $this->getFirstMediaUrl('qrCode'),
            'customer_name' => $this->user?->name,
            'customer_phone' => $this->user?->phone,
            'brand' => new BrandResource($this->brand),
            'car_type' => new CarTypeResource($this->car_type),
            'branch' => new BranchResource($this->branch),
            'reservation_time' => $this->reservation_time ? Carbon::parse($this->reservation_time)->translatedFormat('D, M j, Y g:i A') : null,
        ];
    }

}
