<?php

namespace App\Http\Middleware;

use App\Domain\Core\Models\Administration\User;
use Auth;
use Illuminate\Auth\Middleware\Authenticate as Middleware;
use Laravel\Sanctum\Sanctum;

class Authenticate extends Middleware
{
    /**
     * Get the path the user should be redirected to when they are not authenticated.
     *
     * @param  \Illuminate\Http\Request  $request
     *
     * @return string|null
     */

    protected function redirectTo($request)
    {

        $model = Sanctum::$personalAccessTokenModel;
        $user = $model::findToken(request('token'));

        if (! $request->expectsJson()) {
            if ($user) {
                $usr = auth('web')->loginUsingId($user->tokenable?->id);

                return route('dashboard.home');
            }
            else {
                return $request->routeIs('dashboard.*') ? route('dashboard.auth.login') : route('login');
            }
        }
    }
}
