<?php

namespace App\Http\Controllers\Frontend\Auth\Actions;

use App\Domain\Core\Models\Otp;
use Illuminate\Support\Facades\Log;
use MoemenGaballah\Msegat\Msegat;
use Twilio\Rest\Client;

class ArmadarSms
{
    private $token;
    private $gateway_url;

    public function __construct()
    {

        $this->token = config("ArmadarSms.token");
        $this->gateway_url = "https://app.mobile.net.sa/api/v1";
    }

    /**
     * @param $user
     * @return Client
     */
    public function send($user, $sendAtOption = 'Now')
    {
        $otp = 11111;//random_int(10000, 99999); // Generate a 5-digit OTP
        try {
            $msg = Msegat::sendMessage($user->phone, __('Your Otp Code is :') . ' ' . $otp);
            Log::info($user->phone . ' ' . __('Your Otp Code is :') . ' ' . $otp);
        } catch (\Exception $e) {
            // Get error here
        }
        Otp::updateOrCreate(
            [
                'phone' => $user->phone,
                'user_id' => $user->id,
            ], [
            'otp' => $otp
        ]);
        return true;
    }

    /**
     * @param $code
     * @param $user
     * @return mixed
     */
    public function CheckCode($code, $phone)
    {
        $storedOTP = Otp::where('phone', $phone)->orderBy('id', 'desc')->first();
        if ($storedOTP && $code === $storedOTP->otp) {
            // clear old otp
            Otp::where('phone', $phone)->delete();
            return true;
        } else {
            return false;
        }
    }
}
