<?php

namespace App\Http\Controllers\Dashboard\Core;

use App\Domain\Core\Models\Area;
use App\Domain\Core\Models\City;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Domain\Core\Enums\CorePermissions;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;
use App\Domain\Core\Datatables\StateDatatable;
use App\Domain\Core\Models\State;

class StateController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;

    protected string $name = 'State';
    protected string $path = 'dashboard.core.states';
    protected string $datatable = StateDatatable::class;
    protected string $model = State::class;
    protected array $permissions = [CorePermissions::class, 'states'];


    protected function rules()
    {
        return [
            'title' => 'required|array',
            'title.*' => 'required|string',
            'city_id' => 'required|integer|exists:cities,id',
        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [
            'cities' => toMap(City::get(), 'id', 'title'),
        ];
    }
}
