<?php

namespace App\Http\Controllers\Dashboard\Core;

use Illuminate\Support\Arr;
use Illuminate\Http\UploadedFile;
use App\Domain\Core\Models\Placeholder;
use Illuminate\Database\Eloquent\Model;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Domain\Core\Enums\CorePermissions;
use App\Support\Dashboard\Crud\WithUpdate;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Domain\Core\Datatables\SliderDatatable;
use App\Domain\Core\Datatables\PlaceholderDatatable;
use App\Http\Controllers\Dashboard\DashboardController;

class PlaceholderController extends DashboardController
{
    use WithDatatable, WithForm, WithStore, WithUpdate, WithDestroy;

    protected string $name = 'Placeholder';
    protected string $path = 'dashboard.core.placeholders';
    protected string $datatable = PlaceholderDatatable::class;
    protected string $model = Placeholder::class;
    protected array $permissions = [CorePermissions::class, 'placeholders'];

    protected function rules()
    {
        $validation = [
            // 'name' => 'required|string|max:255',
            'value' => 'required|string|max:255',
        ];

        return $validation;
    }


    protected function storeAction(array $validated)
    {
        $model = ($this->model)::create($validated);
    }

    protected function updateAction(array $validated, Model $model)
    {
        $model->update($validated);
    }

    protected function formData(?Model $model = null): array
    {

        return [
        ];
    }
}
