<?php

namespace App\Http\Controllers\Dashboard\Blog;

use App\Domain\Blog\Datatables\PostCategoryDatatable;
use App\Domain\Blog\Models\PostCategory;
use App\Domain\Core\Enums\CorePermissions;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Support\Dashboard\Crud\WithDatatable;
use App\Support\Dashboard\Crud\WithDestroy;
use App\Support\Dashboard\Crud\WithForm;
use App\Support\Dashboard\Crud\WithStore;
use App\Support\Dashboard\Crud\WithUpdate;
use Illuminate\Database\Eloquent\Model;

class PostCategoryController extends DashboardController
{
    use WithDatatable,  WithForm , WithStore ,WithUpdate , WithDestroy;

    protected string $name = 'PostCategory';

    protected string $path = 'dashboard.blog.post-categories';

    protected string $datatable = PostCategoryDatatable::class;

    protected string $model = PostCategory::class;

    protected array $permissions = [CorePermissions::class, 'post_categories'];

    protected function rules()
    {
        return [
            'name' => 'required|array',
            'name.*' => 'required|string',
        ];
    }

    protected function formData(?Model $model = null): array
    {
        return [

        ];
    }
}
