<?php

namespace App\Domain\Core\Datatables;

use App\Domain\Core\Models\Contact;
use App\Support\Dashboard\Datatables\BaseDatatable;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class ContactDatatable extends BaseDatatable
{
    protected bool $indexer = false;

    public function query(): Builder
    {
        return Contact::query()->with('user');
    }

    protected function filters(): array
    {
        return [
            'name' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            },
            'phone' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            }
        ];
    }

    protected function customColumns(): array
    {
        return [
            'name' => function ($model) {
                return $model?->user ? $model->user?->first_name . ' ' . $model->user?->last_name : $model->name;
            },
            'phone' => function ($model) {
                return $model?->user ? $model->user?->phone : $model->phone;
            }
        ];
    }

    protected function columns(): array
    {
        return [
            Column::make('id')->title(__('ID')),
            Column::make('name')->title(__('Name')),
            Column::make('phone')->title(__('Phone')),
            Column::make('title')->title(__('Title')),
            Column::make('message')->title(__('message')),
            Column::make('seen')->title(__('seen')),
        ];
    }
}
