<?php

namespace App\Console;

use App\Domain\Link\Models\Link;
use App\Jobs\TakeScreenshotJob;
use App\Support\Commands\Generators\GenerateCommand;
use App\Support\Commands\LocalizeCommand;
use App\Support\Commands\TranslateToArabic;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        GenerateCommand::class,
        LocalizeCommand::class,
        TranslateToArabic::class,
    ];

    protected function schedule(Schedule $schedule)
    {
        $schedule->command('telescope:clear')->weeklyOn(1, '02:00');

        // جدولة الوظيفة لأخذ اللقطات كل 24 ساعة
        $schedule->call(function () {
            $links = Link::all();
            foreach ($links as $link) {
                TakeScreenshotJob::dispatch($link);
            }
        })->daily();
    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');
        $this->load(__DIR__ . '/../Support/Commands/Generators/Commands');

//        require base_path('routes/console.php');
    }

    protected function bootstrappers()
    {
        return array_merge(
            [\Bugsnag\BugsnagLaravel\OomBootstrapper::class],
            parent::bootstrappers(),
        );
    }
}
